/*
** Automatically generated from `random.system_rng.m'
** by the Mercury compiler,
** version rotd-2025-12-29
** configured for x86_64-pc-linux-gnu.
** Do not edit.
**
** The autoconfigured grade settings governing
** the generation of this C file were
**
** TAG_BITS=2
** UNBOXED_FLOAT=no
** UNBOXED_INT64S=no
** PREGENERATED_DIST=yes
** HIGHLEVEL_CODE=yes
**
** END_OF_C_GRADE_INFO
*/


// :- module random.system_rng.
// :- implementation.

/*
INIT mercury__random__system_rng__init
ENDINIT
*/

#include "random.system_rng.mih"


#include "array.mih"
#include "assoc_list.mih"
#include "benchmarking.mih"
#include "bitmap.mih"
#include "bool.mih"
#include "builtin.mih"
#include "calendar.mih"
#include "char.mih"
#include "construct.mih"
#include "cord.mih"
#include "counter.mih"
#include "deconstruct.mih"
#include "dir.mih"
#include "enum.mih"
#include "exception.mih"
#include "fat_sparse_bitset.mih"
#include "fatter_sparse_bitset.mih"
#include "float.mih"
#include "int.mih"
#include "int16.mih"
#include "int32.mih"
#include "int64.mih"
#include "int8.mih"
#include "integer.mih"
#include "io.mih"
#include "list.mih"
#include "map.mih"
#include "math.mih"
#include "maybe.mih"
#include "mercury_term_lexer.mih"
#include "mercury_term_parser.mih"
#include "mutvar.mih"
#include "one_or_more.mih"
#include "ops.mih"
#include "pair.mih"
#include "pretty_printer.mih"
#include "private_builtin.mih"
#include "random.mih"
#include "require.mih"
#include "rtti_implementation.mih"
#include "set.mih"
#include "set_ordlist.mih"
#include "set_tree234.mih"
#include "solutions.mih"
#include "sparse_bitset.mih"
#include "stack.mih"
#include "stm_builtin.mih"
#include "store.mih"
#include "stream.mih"
#include "string.mih"
#include "table_builtin.mih"
#include "term.mih"
#include "term_context.mih"
#include "term_conversion.mih"
#include "term_int.mih"
#include "term_io.mih"
#include "term_subst.mih"
#include "term_unify.mih"
#include "term_vars.mih"
#include "time.mih"
#include "tree234.mih"
#include "tree_bitset.mih"
#include "type_desc.mih"
#include "uint.mih"
#include "uint16.mih"
#include "uint32.mih"
#include "uint64.mih"
#include "uint8.mih"
#include "unit.mih"
#include "univ.mih"
#include "varset.mih"
#include "version_array.mih"
#include "io.call_system.mih"
#include "io.environment.mih"
#include "io.error_util.mih"
#include "io.file.mih"
#include "io.primitives_read.mih"
#include "io.primitives_write.mih"
#include "io.stream_db.mih"
#include "io.stream_ops.mih"
#include "io.text_read.mih"
#include "stream.string_writer.mih"
#include "string.builder.mih"
#include "string.format.mih"
#include "string.parse_runtime.mih"
#include "string.parse_util.mih"
#include "string.to_string.mih"

#line 572 "random.system_rng.m"


#include "mercury_memory.h"          // For MR_GC_NEW.
#include "mercury_misc.h"            // For MR_fatal_error.
#include "mercury_runtime_util.h"    // For MR_strerror.
#include "mercury_regs.h"            // For MR_{save,restore}_transient_hp
#include "mercury_reg_workarounds.h" // For MR_memcpy.
#include "mercury_std.h"             // For MR_TRUE, MR_FALSE etc.
#include "mercury_string.h"          // For MR_make_aligned_string_copy etc.
#include "mercury_types.h"           // For MR_Bool.
#include "mercury_windows.h"

#if defined(ML_SYSRAND_IMPL_URANDOM)
  #if defined(MR_HAVE_UNISTD_H)
    #include <unistd.h>
  #endif
  #if defined(MR_HAVE_FCNTL_H)
    #include <fcntl.h>
  #endif
  #if defined(MR_HAVE_SYS_STAT_H)
    #include <sys/stat.h>
  #endif
#endif

#include <errno.h>
#include <stdint.h>

// On Windows we need to ensure that _CRT_RAND_S is defined before stdlib.h
// is included but this must be done in runtime/mercury_std.h.
#include <stdlib.h>

// When succeeded is MR_TRUE, returns a handle through which the system
// RNG can be accessed; err_msg will point to the empty string in this case.
// When succeeded is MR_FALSE, the value return is not a valid handle and
// err_msg will point to a string (on the Mercury heap) describing why a handle
// for the system RNG could not be acquired.
//
static ML_SystemRandomHandle ML_random_open(MR_Bool *succeeded,
    MR_String *err_msg);

// Attempt to close the handle to the system RNG.
// Returns MR_TRUE on success with err_msg pointing to the empty string.
// Returns MR_FALSE on failure with err_msg pointing to a string (on the
// Mercury heap) that describes why the handle could not be closed.
//
static MR_Bool ML_random_close(ML_SystemRandomHandle handle, MR_String *err_msg);

// Fill buffer with len random bytes generated by the system RNG.
// Returns MR_TRUE if len bytes were generated; err_msg will point to the empty
// string.
// Returns MR_FALSE if the system RNG has been unable to generate len bytes.
// In this case the contents of buffer are indeterminate and err_msg will point
// to a string (on the Mercury heap) that describes the problem.
//
static MR_Bool ML_random_generate_bytes(ML_SystemRandomHandle handle,
    unsigned char *buffer, size_t len, MR_String *err_msg);




static MR_bool MR_CALL 
mercury__random__system_rng____Unify____system_rng_0_0_10001(
  MR_Box wrapper_arg_1,
  MR_Box wrapper_arg_2);

static void MR_CALL 
mercury__random__system_rng____Compare____system_rng_0_0_10001(
  MR_Box * wrapper_arg_1,
  MR_Box wrapper_arg_2,
  MR_Box wrapper_arg_3);

static void MR_CALL 
mercury__random__system_rng__ClassMethod_for_random__urandom____random__system_rng__system_rng__arity0__io__state__arity0______random__generate_uint8_4_4_p_0_10001(
  MR_Box closure_arg,
  MR_Box wrapper_arg_1,
  MR_Box * wrapper_arg_2,
  MR_Box wrapper_arg_3,
  MR_Box * wrapper_arg_4);

static void MR_CALL 
mercury__random__system_rng__ClassMethod_for_random__urandom____random__system_rng__system_rng__arity0__io__state__arity0______random__generate_uint16_4_4_p_0_10001(
  MR_Box closure_arg,
  MR_Box wrapper_arg_1,
  MR_Box * wrapper_arg_2,
  MR_Box wrapper_arg_3,
  MR_Box * wrapper_arg_4);

static void MR_CALL 
mercury__random__system_rng__ClassMethod_for_random__urandom____random__system_rng__system_rng__arity0__io__state__arity0______random__generate_uint32_4_4_p_0_10001(
  MR_Box closure_arg,
  MR_Box wrapper_arg_1,
  MR_Box * wrapper_arg_2,
  MR_Box wrapper_arg_3,
  MR_Box * wrapper_arg_4);

static void MR_CALL 
mercury__random__system_rng__ClassMethod_for_random__urandom____random__system_rng__system_rng__arity0__io__state__arity0______random__generate_uint64_4_4_p_0_10001(
  MR_Box closure_arg,
  MR_Box wrapper_arg_1,
  MR_Box * wrapper_arg_2,
  MR_Box wrapper_arg_3,
  MR_Box * wrapper_arg_4);


static /* final */ const MR_Box mercury__random__system_rng_scalar_common_1[1][3];

static /* final */ const MR_Box mercury__random__system_rng_scalar_common_2[1][4];

static /* final */ const MR_Box mercury__random__system_rng_scalar_common_3[1][5];




static /* final */ const MR_Box mercury__random__system_rng_scalar_common_1[1][3] = {
  /* row   0 */
  {
    ((MR_Box) (base_typeclass_info_stream__stream__arity2__io__text_output_stream__arity0__io__state__arity0__)),
    ((MR_Box) (&mercury__io__io__type_ctor_info_text_output_stream_0)),
    ((MR_Box) (&mercury__io__io__type_ctor_info_state_0))
  },
};

static /* final */ const MR_Box mercury__random__system_rng_scalar_common_2[1][4] = {
  /* row   0 */
  {
    ((MR_Box) (base_typeclass_info_stream__output__arity2__io__text_output_stream__arity0__io__state__arity0__)),
    ((MR_Box) (&mercury__random__system_rng_scalar_common_1[0])),
    ((MR_Box) (&mercury__io__io__type_ctor_info_text_output_stream_0)),
    ((MR_Box) (&mercury__io__io__type_ctor_info_state_0))
  },
};

static /* final */ const MR_Box mercury__random__system_rng_scalar_common_3[1][5] = {
  /* row   0 */
  {
    ((MR_Box) (base_typeclass_info_stream__writer__arity3__io__text_output_stream__arity0__string__arity0__io__state__arity0__)),
    ((MR_Box) (&mercury__random__system_rng_scalar_common_2[0])),
    ((MR_Box) (&mercury__io__io__type_ctor_info_text_output_stream_0)),
    ((MR_Box) (&mercury__builtin__builtin__type_ctor_info_string_0)),
    ((MR_Box) (&mercury__io__io__type_ctor_info_state_0))
  },
};



#include "array.mh"
#include "benchmarking.mh"
#include "bitmap.mh"
#include "builtin.mh"
#include "char.mh"
#include "construct.mh"
#include "dir.mh"
#include "exception.mh"
#include "float.mh"
#include "int.mh"
#include "int16.mh"
#include "int32.mh"
#include "int64.mh"
#include "int8.mh"
#include "io.mh"
#include "math.mh"
#include "pretty_printer.mh"
#include "private_builtin.mh"
#include "rtti_implementation.mh"
#include "stm_builtin.mh"
#include "store.mh"
#include "string.mh"
#include "table_builtin.mh"
#include "time.mh"
#include "type_desc.mh"
#include "uint.mh"
#include "uint16.mh"
#include "uint32.mh"
#include "uint64.mh"
#include "uint8.mh"
#include "version_array.mh"
#include "io.environment.mh"
#include "io.error_util.mh"
#include "io.file.mh"
#include "io.primitives_read.mh"
#include "io.primitives_write.mh"
#include "io.stream_db.mh"
#include "io.stream_ops.mh"
#include "io.text_read.mh"
#include "random.system_rng.mh"
#line 630 "random.system_rng.m"


#if defined(ML_SYSRAND_IMPL_URANDOM)

static ML_SystemRandomHandle
ML_random_open(MR_Bool *succeeded, MR_String *err_msg)
{
    int fd;
    char errbuf[MR_STRERROR_BUF_SIZE];
    const char *errno_msg;
    ML_SystemRandomHandle handle;

    do {
        fd = open("/dev/urandom", O_RDONLY);
    } while (fd == -1 && MR_is_eintr(errno));

    if (fd == -1) {
        errno_msg = MR_strerror(errno, errbuf, sizeof(errbuf));
        MR_save_transient_hp();
        MR_make_aligned_string_copy(*err_msg, errno_msg);
        MR_restore_transient_hp();
        *succeeded = MR_NO;
        handle = NULL;
    } else {
        handle = MR_GC_NEW(struct ML_SystemRandomHandle_Struct);
        handle->ML_srh_fd = fd;
        *err_msg = MR_make_string_const("");
        *succeeded = MR_YES;
    }

    return handle;
}

static MR_Bool
ML_random_close(ML_SystemRandomHandle handle, MR_String *err_msg)
{
    char errbuf[MR_STRERROR_BUF_SIZE];
    const char *errno_msg;

    if (close(handle->ML_srh_fd) == -1) {
        errno_msg = MR_strerror(errno, errbuf, sizeof(errbuf));
        MR_save_transient_hp();
        MR_make_aligned_string_copy(*err_msg, errno_msg);
        MR_restore_transient_hp();
        return MR_NO;
    } else {
        handle->ML_srh_fd = -1;
        *err_msg = MR_make_string_const("");
        return MR_YES;
    }
}

static MR_Bool
ML_random_generate_bytes(ML_SystemRandomHandle handle,
    unsigned char *buffer, size_t len, MR_String *err_msg)
{
    int i;
    char errbuf[MR_STRERROR_BUF_SIZE];
    const char *errno_msg;

    for (i = 0; i < len; ) {
        size_t to_read = len - i;
        ssize_t bytes_read = read(handle->ML_srh_fd, buffer, to_read);
        if (bytes_read == -1) {
            if (MR_is_eintr(errno)) {
                continue;
            } else {
                errno_msg = MR_strerror(errno, errbuf, sizeof(errbuf));
                MR_save_transient_hp();
                MR_make_aligned_string_copy(*err_msg, errno_msg);
                MR_restore_transient_hp();
                return MR_FALSE;
            }
        }
        i += bytes_read;
    }

    *err_msg = MR_make_string_const("");
    return MR_TRUE;
}

#elif defined(ML_SYSRAND_IMPL_ARC4RANDOM)

static ML_SystemRandomHandle
ML_random_open(MR_Bool *succeeded, MR_String *err_msg)
{
    ML_SystemRandomHandle handle =
        MR_GC_NEW(struct ML_SystemRandomHandle_Struct);
    handle->ML_srh_is_open = MR_TRUE;
    *succeeded = MR_TRUE;
    *err_msg = MR_make_string_const("");
    return handle;
}

static MR_Bool
ML_random_close(ML_SystemRandomHandle handle, MR_String *err_msg)
{
    if (handle->ML_srh_is_open) {
        handle->ML_srh_is_open = MR_FALSE;
        *err_msg = MR_make_string_const("");
        return MR_TRUE;
    } else {
        *err_msg =
            MR_make_string_const("system RNG handle is already closed");
        return MR_FALSE;
    }
}

static MR_Bool
ML_random_generate_bytes(ML_SystemRandomHandle handle,
    unsigned char *buffer, size_t len, MR_String *err_msg)
{
    if (handle->ML_srh_is_open) {
        arc4random_buf(buffer, len);
        *err_msg = MR_make_string_const("");
        return MR_TRUE;
    } else {
        *err_msg = MR_make_string_const("system RNG handle is closed");
        return MR_FALSE;
    }
}

#elif defined(ML_SYSRAND_IMPL_RAND_S)

static ML_SystemRandomHandle
ML_random_open(MR_Bool *succeeded, MR_String *err_msg)
{
    ML_SystemRandomHandle handle =
        MR_GC_NEW(struct ML_SystemRandomHandle_Struct);
    handle->ML_srh_is_open = MR_TRUE;
    *succeeded = MR_TRUE;
    *err_msg = MR_make_string_const("");
    return handle;
}

static MR_Bool
ML_random_close(ML_SystemRandomHandle handle, MR_String *err_msg)
{
    if (handle->ML_srh_is_open) {
        handle->ML_srh_is_open = MR_FALSE;
        *err_msg = MR_make_string_const("");
        return MR_TRUE;
    } else {
        *err_msg =
            MR_make_string_const("system RNG handle is already closed");
        return MR_FALSE;
    }
}

static MR_Bool
ML_random_generate_bytes(ML_SystemRandomHandle handle,
    unsigned char *buffer, size_t len, MR_String *err_msg)
{
    int err;
    unsigned int n;
    size_t num_to_read = len;

    if (!handle->ML_srh_is_open) {
        *err_msg = MR_make_string_const("system RNG handle is closed");
        return MR_FALSE;
    }

    while (num_to_read > 0) {
        if (num_to_read < 4) {
            err = rand_s(&n);
            if (err != 0) {
                goto rand_s_failure_handler;
            }
            MR_memcpy(buffer, (unsigned char *) &n, num_to_read);
            break;
        } else {
            err = rand_s((unsigned int *) buffer);
            if (err != 0) {
                goto rand_s_failure_handler;
            }
            num_to_read -= 4;
            buffer += 4;
        }
    }

    *err_msg = MR_make_string_const("");
    return MR_TRUE;

rand_s_failure_handler:

    *err_msg = MR_make_string_const("rand_s failed");
    return MR_FALSE;
}

#else // ML_SYSRAND_IMPL_NONE

static ML_SystemRandomHandle
ML_random_open(MR_Bool *succeeded, MR_String *err_msg)
{
    succeeded = MR_FALSE;
    *err_msg = MR_make_string_const("No system RNG available");
    return 0; // Dummy value.
}

static MR_Bool
ML_random_close(ML_SystemRandomHandle handle, MR_String *err_msg)
{
    MR_fatal_error("ML_random_close - no system RNG available.");
}

static MR_Bool
ML_random_generate_bytes(ML_SystemRandomHandle handle,
    unsigned char *buffer, size_t len, MR_String *err_msg)
{
    MR_fatal_error("ML_random_generate_bytes - no system RNG available.");
}

#endif




const MR_TypeCtorInfo_Struct mercury__random__system_rng__random__system_rng__type_ctor_info_system_rng_0 = {
  (MR_Integer) 0,
  UINT8_C(18),
  INT8_C(-1),
  MR_TYPECTOR_REP_FOREIGN,
  ((MR_Box) (mercury__random__system_rng____Unify____system_rng_0_0_10001)),
  ((MR_Box) (mercury__random__system_rng____Compare____system_rng_0_0_10001)),
  (MR_String) "random.system_rng",
  (MR_String) "system_rng",
  { NULL },
  { NULL },
  (MR_Integer) -1,
  UINT16_C(0),
  NULL,

};

const MR_BaseTypeclassInfo base_typeclass_info_random__urandom__arity2__random__system_rng__system_rng__arity0__io__state__arity0__[9] = {
  ((MR_Box) ((MR_Integer) 0)),
  ((MR_Box) ((MR_Integer) 0)),
  ((MR_Box) ((MR_Integer) 0)),
  ((MR_Box) ((MR_Integer) 2)),
  ((MR_Box) ((MR_Integer) 4)),
  ((MR_Box) (mercury__random__system_rng__ClassMethod_for_random__urandom____random__system_rng__system_rng__arity0__io__state__arity0______random__generate_uint8_4_4_p_0_10001)),
  ((MR_Box) (mercury__random__system_rng__ClassMethod_for_random__urandom____random__system_rng__system_rng__arity0__io__state__arity0______random__generate_uint16_4_4_p_0_10001)),
  ((MR_Box) (mercury__random__system_rng__ClassMethod_for_random__urandom____random__system_rng__system_rng__arity0__io__state__arity0______random__generate_uint32_4_4_p_0_10001)),
  ((MR_Box) (mercury__random__system_rng__ClassMethod_for_random__urandom____random__system_rng__system_rng__arity0__io__state__arity0______random__generate_uint64_4_4_p_0_10001))
};

void MR_CALL 
mercury__random__system_rng__ClassMethod_for_random__urandom____random__system_rng__system_rng__arity0__io__state__arity0______random__generate_uint64_4_4_p_0(
  MR_Box HeadVar__1_1,
  uint64_t * HeadVar__2_2)
{
  mercury__random__system_rng__generate_uint64_4_p_0(HeadVar__1_1, HeadVar__2_2);
}

void MR_CALL 
mercury__random__system_rng__ClassMethod_for_random__urandom____random__system_rng__system_rng__arity0__io__state__arity0______random__generate_uint32_4_4_p_0(
  MR_Box HeadVar__1_1,
  uint32_t * HeadVar__2_2)
{
  mercury__random__system_rng__generate_uint32_4_p_0(HeadVar__1_1, HeadVar__2_2);
}

void MR_CALL 
mercury__random__system_rng__ClassMethod_for_random__urandom____random__system_rng__system_rng__arity0__io__state__arity0______random__generate_uint16_4_4_p_0(
  MR_Box HeadVar__1_1,
  uint16_t * HeadVar__2_2)
{
  mercury__random__system_rng__generate_uint16_4_p_0(HeadVar__1_1, HeadVar__2_2);
}

void MR_CALL 
mercury__random__system_rng__ClassMethod_for_random__urandom____random__system_rng__system_rng__arity0__io__state__arity0______random__generate_uint8_4_4_p_0(
  MR_Box HeadVar__1_1,
  uint8_t * HeadVar__2_2)
{
  mercury__random__system_rng__generate_uint8_4_p_0(HeadVar__1_1, HeadVar__2_2);
}

void MR_CALL 
mercury__random__system_rng____Compare____system_rng_0_0(
  MR_Word * HeadVar__1_1,
  MR_Box HeadVar__2_2,
  MR_Box HeadVar__3_3)
{
  MR_Word Cast_HeadVar1_4 = (MR_Word) (HeadVar__2_2);
  MR_Word Cast_HeadVar2_5 = (MR_Word) (HeadVar__3_3);

  mercury__builtin____Compare____c_pointer_0_0(HeadVar__1_1, Cast_HeadVar1_4, Cast_HeadVar2_5);
}

MR_bool MR_CALL 
mercury__random__system_rng____Unify____system_rng_0_0(
  MR_Box HeadVar__1_1,
  MR_Box HeadVar__2_2)
{
  MR_bool succeeded;
  MR_Word Cast_HeadVar1_3 = (MR_Word) (HeadVar__1_1);
  MR_Word Cast_HeadVar2_4 = (MR_Word) (HeadVar__2_2);

  succeeded = mercury__builtin____Unify____c_pointer_0_0(Cast_HeadVar1_3, Cast_HeadVar2_4);
  return succeeded;
}

void MR_CALL 
mercury__random__system_rng__throw_system_rng_error_2_p_0(
  MR_String Pred_3,
  MR_String Msg_4)
{
  MR_String Error_5;
  MR_Word Var_12;
  MR_String Var_15;

  mercury__string__append_3_p_2((MR_String) ": ", Msg_4, &Var_15);
  mercury__string__append_3_p_2(Pred_3, Var_15, &Error_5);
  Var_12 = (MR_Word) (Error_5);
  {
    mercury__exception__throw_1_p_0((MR_Word) (&mercury__exception__exception__type_ctor_info_software_error_0), ((MR_Box) (Var_12)));
    return;
  }
}

void MR_CALL 
mercury__random__system_rng__generate_uint64_4_p_0(
  MR_Box Handle_5,
  uint64_t * U64_6)
{
  MR_Word IsOk_8;
  MR_String ErrorMsg_9;

  mercury__random__system_rng__do_generate_uint64_6_p_0(Handle_5, U64_6, &IsOk_8, &ErrorMsg_9);
  switch (IsOk_8) {
    default: /*NOTREACHED*/ MR_assert(0);
    case (MR_Integer) 0:
      {
        MR_String Error_14;
        MR_Word Var_21;
        MR_String Var_24;

        mercury__string__append_3_p_2((MR_String) ": ", ErrorMsg_9, &Var_24);
        mercury__string__append_3_p_2((MR_String) "predicate \140random.system_rng.generate_uint64\'/4", Var_24, &Error_14);
        Var_21 = (MR_Word) (Error_14);
        {
          mercury__exception__throw_1_p_0((MR_Word) (&mercury__exception__exception__type_ctor_info_software_error_0), ((MR_Box) (Var_21)));
          return;
        }
      }
      break;
    case (MR_Integer) 1:
      {
      }
      break;
  }
}

void MR_CALL 
mercury__random__system_rng__do_generate_uint64_6_p_0(
  MR_Box Handle_1,
  uint64_t * U64_2,
  MR_Word * IsOk_3,
  MR_String * ErrorMsg_4)
{
{
#define MR_PROC_LABEL mercury__random__system_rng__do_generate_uint64_6_p_0

	ML_SystemRandomHandle Handle;
	uint64_t U64;
	MR_Word IsOk;
	MR_String ErrorMsg;

	Handle = (ML_SystemRandomHandle) Handle_1 ;
		{

    union {
        uint64_t n;
        unsigned char buffer[8];
    } u;
    IsOk = ML_random_generate_bytes(Handle, u.buffer, sizeof(u.buffer),
        &ErrorMsg);
    U64 = u.n;


		;}
#undef MR_PROC_LABEL
	*U64_2  = U64;
	*IsOk_3  = IsOk;
	*ErrorMsg_4  = ErrorMsg;
}
}

void MR_CALL 
mercury__random__system_rng__generate_uint32_4_p_0(
  MR_Box Handle_5,
  uint32_t * U32_6)
{
  MR_Word IsOk_8;
  MR_String ErrorMsg_9;

  mercury__random__system_rng__do_generate_uint32_6_p_0(Handle_5, U32_6, &IsOk_8, &ErrorMsg_9);
  switch (IsOk_8) {
    default: /*NOTREACHED*/ MR_assert(0);
    case (MR_Integer) 0:
      {
        MR_String Error_14;
        MR_Word Var_21;
        MR_String Var_24;

        mercury__string__append_3_p_2((MR_String) ": ", ErrorMsg_9, &Var_24);
        mercury__string__append_3_p_2((MR_String) "predicate \140random.system_rng.generate_uint32\'/4", Var_24, &Error_14);
        Var_21 = (MR_Word) (Error_14);
        {
          mercury__exception__throw_1_p_0((MR_Word) (&mercury__exception__exception__type_ctor_info_software_error_0), ((MR_Box) (Var_21)));
          return;
        }
      }
      break;
    case (MR_Integer) 1:
      {
      }
      break;
  }
}

void MR_CALL 
mercury__random__system_rng__do_generate_uint32_6_p_0(
  MR_Box Handle_1,
  uint32_t * U32_2,
  MR_Word * IsOk_3,
  MR_String * ErrorMsg_4)
{
{
#define MR_PROC_LABEL mercury__random__system_rng__do_generate_uint32_6_p_0

	ML_SystemRandomHandle Handle;
	uint32_t U32;
	MR_Word IsOk;
	MR_String ErrorMsg;

	Handle = (ML_SystemRandomHandle) Handle_1 ;
		{

    union {
        uint32_t n;
        unsigned char buffer[4];
    } u;
    IsOk = ML_random_generate_bytes(Handle, u.buffer, sizeof(u.buffer),
        &ErrorMsg);
    U32 = u.n;


		;}
#undef MR_PROC_LABEL
	*U32_2  = U32;
	*IsOk_3  = IsOk;
	*ErrorMsg_4  = ErrorMsg;
}
}

void MR_CALL 
mercury__random__system_rng__generate_uint16_4_p_0(
  MR_Box Handle_5,
  uint16_t * U16_6)
{
  MR_Word IsOk_8;
  MR_String ErrorMsg_9;

  mercury__random__system_rng__do_generate_uint16_6_p_0(Handle_5, U16_6, &IsOk_8, &ErrorMsg_9);
  switch (IsOk_8) {
    default: /*NOTREACHED*/ MR_assert(0);
    case (MR_Integer) 0:
      {
        MR_String Error_14;
        MR_Word Var_21;
        MR_String Var_24;

        mercury__string__append_3_p_2((MR_String) ": ", ErrorMsg_9, &Var_24);
        mercury__string__append_3_p_2((MR_String) "predicate \140random.system_rng.generate_uint16\'/4", Var_24, &Error_14);
        Var_21 = (MR_Word) (Error_14);
        {
          mercury__exception__throw_1_p_0((MR_Word) (&mercury__exception__exception__type_ctor_info_software_error_0), ((MR_Box) (Var_21)));
          return;
        }
      }
      break;
    case (MR_Integer) 1:
      {
      }
      break;
  }
}

void MR_CALL 
mercury__random__system_rng__do_generate_uint16_6_p_0(
  MR_Box Handle_1,
  uint16_t * U16_2,
  MR_Word * IsOk_3,
  MR_String * ErrorMsg_4)
{
{
#define MR_PROC_LABEL mercury__random__system_rng__do_generate_uint16_6_p_0

	ML_SystemRandomHandle Handle;
	uint16_t U16;
	MR_Word IsOk;
	MR_String ErrorMsg;

	Handle = (ML_SystemRandomHandle) Handle_1 ;
		{

    union {
        uint16_t n;
        unsigned char buffer[2];
    } u;
    IsOk = ML_random_generate_bytes(Handle, u.buffer, sizeof(u.buffer),
        &ErrorMsg);
    U16 = u.n;


		;}
#undef MR_PROC_LABEL
	*U16_2  = U16;
	*IsOk_3  = IsOk;
	*ErrorMsg_4  = ErrorMsg;
}
}

void MR_CALL 
mercury__random__system_rng__generate_uint8_4_p_0(
  MR_Box Handle_5,
  uint8_t * U8_6)
{
  MR_Word IsOk_8;
  MR_String ErrorMsg_9;

  mercury__random__system_rng__do_generate_uint8_6_p_0(Handle_5, U8_6, &IsOk_8, &ErrorMsg_9);
  switch (IsOk_8) {
    default: /*NOTREACHED*/ MR_assert(0);
    case (MR_Integer) 0:
      {
        MR_String Error_14;
        MR_Word Var_21;
        MR_String Var_24;

        mercury__string__append_3_p_2((MR_String) ": ", ErrorMsg_9, &Var_24);
        mercury__string__append_3_p_2((MR_String) "predicate \140random.system_rng.generate_uint8\'/4", Var_24, &Error_14);
        Var_21 = (MR_Word) (Error_14);
        {
          mercury__exception__throw_1_p_0((MR_Word) (&mercury__exception__exception__type_ctor_info_software_error_0), ((MR_Box) (Var_21)));
          return;
        }
      }
      break;
    case (MR_Integer) 1:
      {
      }
      break;
  }
}

void MR_CALL 
mercury__random__system_rng__do_generate_uint8_6_p_0(
  MR_Box Handle_1,
  uint8_t * U8_2,
  MR_Word * IsOk_3,
  MR_String * ErrorMsg_4)
{
{
#define MR_PROC_LABEL mercury__random__system_rng__do_generate_uint8_6_p_0

	ML_SystemRandomHandle Handle;
	uint8_t U8;
	MR_Word IsOk;
	MR_String ErrorMsg;

	Handle = (ML_SystemRandomHandle) Handle_1 ;
		{

    union {
        uint8_t n;
        unsigned char buffer[1];
    } u;
    IsOk = ML_random_generate_bytes(Handle, u.buffer, sizeof(u.buffer),
        &ErrorMsg);
    U8 = u.n;


		;}
#undef MR_PROC_LABEL
	*U8_2  = U8;
	*IsOk_3  = IsOk;
	*ErrorMsg_4  = ErrorMsg;
}
}

void MR_CALL 
mercury__random__system_rng__close_system_rng_3_p_0(
  MR_Box Handle_4)
{
  MR_Word IsOk_6;
  MR_String ErrorMsg_7;

  mercury__random__system_rng__do_close_system_rng_5_p_0(Handle_4, &IsOk_6, &ErrorMsg_7);
  switch (IsOk_6) {
    default: /*NOTREACHED*/ MR_assert(0);
    case (MR_Integer) 0:
      {
        MR_String Error_12;
        MR_Word Var_19;
        MR_String Var_22;

        mercury__string__append_3_p_2((MR_String) ": ", ErrorMsg_7, &Var_22);
        mercury__string__append_3_p_2((MR_String) "predicate \140random.system_rng.close_system_rng\'/3", Var_22, &Error_12);
        Var_19 = (MR_Word) (Error_12);
        {
          mercury__exception__throw_1_p_0((MR_Word) (&mercury__exception__exception__type_ctor_info_software_error_0), ((MR_Box) (Var_19)));
          return;
        }
      }
      break;
    case (MR_Integer) 1:
      {
      }
      break;
  }
}

void MR_CALL 
mercury__random__system_rng__do_close_system_rng_5_p_0(
  MR_Box Handle_1,
  MR_Word * IsOk_2,
  MR_String * ErrorMsg_3)
{
{
#define MR_PROC_LABEL mercury__random__system_rng__do_close_system_rng_5_p_0

	ML_SystemRandomHandle Handle;
	MR_Word IsOk;
	MR_String ErrorMsg;

	Handle = (ML_SystemRandomHandle) Handle_1 ;
		{

    IsOk = ML_random_close(Handle, &ErrorMsg);


		;}
#undef MR_PROC_LABEL
	*IsOk_2  = IsOk;
	*ErrorMsg_3  = ErrorMsg;
}
}

void MR_CALL 
mercury__random__system_rng__open_system_rng_3_p_0(
  MR_Word * Result_4)
{
  MR_Box Handle_6;
  MR_Word IsOk_7;
  MR_String ErrorMsg_8;

  mercury__random__system_rng__do_open_system_rng_5_p_0(&Handle_6, &IsOk_7, &ErrorMsg_8);
  switch (IsOk_7) {
    default: /*NOTREACHED*/ MR_assert(0);
    case (MR_Integer) 0:
      {
        MR_Word base;
        base = (MR_Word) MR_mkword(1, MR_new_object(MR_Word, (1 * sizeof(MR_Word)), NULL, NULL));
        *Result_4 = base;
        MR_hl_field(1, base, 0) = ((MR_Box) (ErrorMsg_8));
      }
      break;
    case (MR_Integer) 1:
      {
        MR_Word base;
        base = (MR_Word) MR_new_object(MR_Word, (1 * sizeof(MR_Word)), NULL, NULL);
        *Result_4 = base;
        MR_hl_field(0, base, 0) = ((MR_Box) (Handle_6));
      }
      break;
  }
}

void MR_CALL 
mercury__random__system_rng__do_open_system_rng_5_p_0(
  MR_Box * Handle_1,
  MR_Word * IsOk_2,
  MR_String * ErrorMsg_3)
{
{
#define MR_PROC_LABEL mercury__random__system_rng__do_open_system_rng_5_p_0

	ML_SystemRandomHandle Handle;
	MR_Word IsOk;
	MR_String ErrorMsg;

		{

    Handle = ML_random_open(&IsOk, &ErrorMsg);


		;}
#undef MR_PROC_LABEL
	*Handle_1  = (MR_Box) Handle;
	*IsOk_2  = IsOk;
	*ErrorMsg_3  = ErrorMsg;
}
}

MR_bool MR_CALL 
mercury__random__system_rng__have_system_rng_0_p_0(void)
{
  MR_bool succeeded;

{
#define MR_PROC_LABEL mercury__random__system_rng__have_system_rng_0_p_0

	MR_bool SUCCESS_INDICATOR;

		{

#if defined(ML_SYSRAND_IMPL_NONE)
    SUCCESS_INDICATOR = MR_FALSE;
#else
    SUCCESS_INDICATOR = MR_TRUE;
#endif


		;}
#undef MR_PROC_LABEL
succeeded  = SUCCESS_INDICATOR;
}
  return succeeded;
}

static MR_bool MR_CALL 
mercury__random__system_rng____Unify____system_rng_0_0_10001(
  MR_Box wrapper_arg_1,
  MR_Box wrapper_arg_2)
{
  MR_bool succeeded;

  succeeded = mercury__random__system_rng____Unify____system_rng_0_0(((MR_Box) (wrapper_arg_1)), ((MR_Box) (wrapper_arg_2)));
  return succeeded;
}

static void MR_CALL 
mercury__random__system_rng____Compare____system_rng_0_0_10001(
  MR_Box * wrapper_arg_1,
  MR_Box wrapper_arg_2,
  MR_Box wrapper_arg_3)
{
  MR_Word conv0_HeadVar__1_1;

  mercury__random__system_rng____Compare____system_rng_0_0(&conv0_HeadVar__1_1, ((MR_Box) (wrapper_arg_2)), ((MR_Box) (wrapper_arg_3)));
  *wrapper_arg_1 = ((MR_Box) (conv0_HeadVar__1_1));
}

static void MR_CALL 
mercury__random__system_rng__ClassMethod_for_random__urandom____random__system_rng__system_rng__arity0__io__state__arity0______random__generate_uint8_4_4_p_0_10001(
  MR_Box closure_arg,
  MR_Box wrapper_arg_1,
  MR_Box * wrapper_arg_2,
  MR_Box wrapper_arg_3,
  MR_Box * wrapper_arg_4)
{
  MR_Box closure = closure_arg;
  uint8_t conv0_HeadVar__2_2;

  mercury__random__system_rng__ClassMethod_for_random__urandom____random__system_rng__system_rng__arity0__io__state__arity0______random__generate_uint8_4_4_p_0(((MR_Box) (wrapper_arg_1)), &conv0_HeadVar__2_2);
  *wrapper_arg_2 = ((MR_Box) (MR_Word) (conv0_HeadVar__2_2));
}

static void MR_CALL 
mercury__random__system_rng__ClassMethod_for_random__urandom____random__system_rng__system_rng__arity0__io__state__arity0______random__generate_uint16_4_4_p_0_10001(
  MR_Box closure_arg,
  MR_Box wrapper_arg_1,
  MR_Box * wrapper_arg_2,
  MR_Box wrapper_arg_3,
  MR_Box * wrapper_arg_4)
{
  MR_Box closure = closure_arg;
  uint16_t conv0_HeadVar__2_2;

  mercury__random__system_rng__ClassMethod_for_random__urandom____random__system_rng__system_rng__arity0__io__state__arity0______random__generate_uint16_4_4_p_0(((MR_Box) (wrapper_arg_1)), &conv0_HeadVar__2_2);
  *wrapper_arg_2 = ((MR_Box) (MR_Word) (conv0_HeadVar__2_2));
}

static void MR_CALL 
mercury__random__system_rng__ClassMethod_for_random__urandom____random__system_rng__system_rng__arity0__io__state__arity0______random__generate_uint32_4_4_p_0_10001(
  MR_Box closure_arg,
  MR_Box wrapper_arg_1,
  MR_Box * wrapper_arg_2,
  MR_Box wrapper_arg_3,
  MR_Box * wrapper_arg_4)
{
  MR_Box closure = closure_arg;
  uint32_t conv0_HeadVar__2_2;

  mercury__random__system_rng__ClassMethod_for_random__urandom____random__system_rng__system_rng__arity0__io__state__arity0______random__generate_uint32_4_4_p_0(((MR_Box) (wrapper_arg_1)), &conv0_HeadVar__2_2);
  *wrapper_arg_2 = ((MR_Box) (MR_Word) (conv0_HeadVar__2_2));
}

static void MR_CALL 
mercury__random__system_rng__ClassMethod_for_random__urandom____random__system_rng__system_rng__arity0__io__state__arity0______random__generate_uint64_4_4_p_0_10001(
  MR_Box closure_arg,
  MR_Box wrapper_arg_1,
  MR_Box * wrapper_arg_2,
  MR_Box wrapper_arg_3,
  MR_Box * wrapper_arg_4)
{
  MR_Box closure = closure_arg;
  uint64_t conv0_HeadVar__2_2;

  mercury__random__system_rng__ClassMethod_for_random__urandom____random__system_rng__system_rng__arity0__io__state__arity0______random__generate_uint64_4_4_p_0(((MR_Box) (wrapper_arg_1)), &conv0_HeadVar__2_2);
  *wrapper_arg_2 = MR_box_uint64(conv0_HeadVar__2_2);
}

void mercury__random__system_rng__init(void)
{
}

void mercury__random__system_rng__init_type_tables(void)
{
  static MR_bool initialised = MR_FALSE;
  if (initialised) return;
  initialised = MR_TRUE;

  MR_register_type_ctor_info(&mercury__random__system_rng__random__system_rng__type_ctor_info_system_rng_0);
}

void mercury__random__system_rng__init_debugger(void)
{
  MR_fatal_error("debugger initialization in MLDS grade");
}

// Ensure everything is compiled with the same grade.
const char *mercury__random__system_rng__grade_check(void)
{
  return &MR_GRADE_VAR;
}

// :- end_module random.system_rng.
