// vim: ts=4 sw=4 expandtab ft=java
//
// Copyright (C) 2009 The University of Melbourne.
// Copyright (C) 2018 The Mercury team.
// This file is distributed under the terms specified in COPYING.LIB.
//
// This is the superclass of all classes generated by the Java back-end
// which correspond to Mercury-defined enumeration types.
//

package jmercury.runtime;

public abstract class MercuryEnum {
    public final int MR_value;

    protected MercuryEnum(int val) {
        MR_value = val;
    }

    @Override
    public boolean equals(Object o) {
        return o != null && o instanceof MercuryEnum &&
            ((MercuryEnum)o).MR_value == this.MR_value;
    }

    @Override
    public int hashCode() {
        return MR_value;
    }
}
