:- module training_cars_small.

% synopsis: Describes the facts that capture the characteristics
%           of cars pulling up to gas stations, and their purchases.
% author:   Douglas M. Auclair (DMA)
% date:     March 21, 2006

:- interface.

:- import_module assoc_list.
:- import_module string.

:- type class
	--->	class(string).

:- type attributes
	--->	attributes(assoc_list(string, string.poly_type)).

:- pred car(int::in, class::out, attributes::out) is semidet.

:- implementation.

:- import_module std_util, pair, list.

% automatically generated facts follow:

car(0, class("fill up only"), attributes(["state/province" - s("WA"), "tag" - s("IPD050"), "year" - i(2004), "month" - i(12), "day" - i(26), "hour" - i(15), "minute" - i(42), "station" - s("mobil"), "fill-ups" - i(4), "record history (days)" - i(27), "weekdays" - i(3), "weekends" - i(1), "preferred day" - s("tuesday"), "day preference %" - i(25), "mean time of visit (minutes after midnight)" - i(195), "standard deviation from mean" - i(293), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(50), "% pay cashier (instead of at pump)" - i(25), "payment method" - s("credit"), "preferred pump" - s("17LG"), "preferred pump %" - i(25)])).
car(1, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("88434BH"), "year" - i(2005), "month" - i(1), "day" - i(5), "hour" - i(17), "minute" - i(25), "station" - s("mobil"), "fill-ups" - i(122), "record history (days)" - i(145), "weekdays" - i(108), "weekends" - i(14), "preferred day" - s("thursday"), "day preference %" - i(22), "mean time of visit (minutes after midnight)" - i(9), "standard deviation from mean" - i(104), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(84), "% pay cashier (instead of at pump)" - i(3), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(31)])).
car(2, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("6DNI590"), "year" - i(2004), "month" - i(11), "day" - i(5), "hour" - i(16), "minute" - i(22), "station" - s("mobil"), "fill-ups" - i(18), "record history (days)" - i(146), "weekdays" - i(15), "weekends" - i(3), "preferred day" - s("wednesday"), "day preference %" - i(22), "mean time of visit (minutes after midnight)" - i(66), "standard deviation from mean" - i(266), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(55), "% pay cashier (instead of at pump)" - i(11), "payment method" - s("credit"), "preferred pump" - s("17YH"), "preferred pump %" - i(44)])).
car(3, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("2876SPL"), "year" - i(2004), "month" - i(12), "day" - i(17), "hour" - i(21), "minute" - i(16), "station" - s("mobil"), "fill-ups" - i(35), "record history (days)" - i(147), "weekdays" - i(21), "weekends" - i(14), "preferred day" - s("saturday"), "day preference %" - i(28), "mean time of visit (minutes after midnight)" - i(34), "standard deviation from mean" - i(197), "different locations" - i(2), "preferred station" - s("shell"), "preferred station %" - i(68), "% pay cashier (instead of at pump)" - i(5), "payment method" - s("credit"), "preferred pump" - s("27LG"), "preferred pump %" - i(31)])).
car(4, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("1374AVL"), "year" - i(2004), "month" - i(10), "day" - i(4), "hour" - i(13), "minute" - i(48), "station" - s("mobil"), "fill-ups" - i(2), "record history (days)" - i(0), "weekdays" - i(2), "weekends" - i(0), "preferred day" - s("tuesday"), "day preference %" - i(100), "mean time of visit (minutes after midnight)" - i(828), "standard deviation from mean" - i(0), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(100), "payment method" - s("credit"), "preferred pump" - s("27HG"), "preferred pump %" - i(100)])).
car(5, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("9YNI627"), "year" - i(2005), "month" - i(3), "day" - i(4), "hour" - i(9), "minute" - i(43), "station" - s("shell"), "fill-ups" - i(73), "record history (days)" - i(149), "weekdays" - i(46), "weekends" - i(27), "preferred day" - s("monday"), "day preference %" - i(26), "mean time of visit (minutes after midnight)" - i(7), "standard deviation from mean" - i(64), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(64), "% pay cashier (instead of at pump)" - i(7), "payment method" - s("credit"), "preferred pump" - s("27HG"), "preferred pump %" - i(32)])).
car(6, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("2QOX837"), "year" - i(2005), "month" - i(3), "day" - i(3), "hour" - i(7), "minute" - i(14), "station" - s("mobil"), "fill-ups" - i(46), "record history (days)" - i(165), "weekdays" - i(33), "weekends" - i(13), "preferred day" - s("friday"), "day preference %" - i(19), "mean time of visit (minutes after midnight)" - i(12), "standard deviation from mean" - i(75), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(5), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(73)])).
car(7, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("5DNI137"), "year" - i(2005), "month" - i(2), "day" - i(13), "hour" - i(21), "minute" - i(51), "station" - s("shell"), "fill-ups" - i(60), "record history (days)" - i(148), "weekdays" - i(43), "weekends" - i(17), "preferred day" - s("wednesday"), "day preference %" - i(20), "mean time of visit (minutes after midnight)" - i(24), "standard deviation from mean" - i(178), "different locations" - i(3), "preferred station" - s("mobil"), "preferred station %" - i(65), "% pay cashier (instead of at pump)" - i(5), "payment method" - s("credit"), "preferred pump" - s("27HG"), "preferred pump %" - i(16)])).
car(8, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("6CNI548"), "year" - i(2004), "month" - i(10), "day" - i(24), "hour" - i(12), "minute" - i(36), "station" - s("shell"), "fill-ups" - i(10), "record history (days)" - i(109), "weekdays" - i(4), "weekends" - i(6), "preferred day" - s("sunday"), "day preference %" - i(60), "mean time of visit (minutes after midnight)" - i(85), "standard deviation from mean" - i(243), "different locations" - i(3), "preferred station" - s("chevron"), "preferred station %" - i(60), "% pay cashier (instead of at pump)" - i(10), "payment method" - s("credit"), "preferred pump" - s("17YH"), "preferred pump %" - i(60)])).
car(9, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("4BNI405"), "year" - i(2005), "month" - i(2), "day" - i(2), "hour" - i(13), "minute" - i(5), "station" - s("mobil"), "fill-ups" - i(56), "record history (days)" - i(147), "weekdays" - i(44), "weekends" - i(12), "preferred day" - s("monday"), "day preference %" - i(28), "mean time of visit (minutes after midnight)" - i(14), "standard deviation from mean" - i(105), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(71), "% pay cashier (instead of at pump)" - i(5), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(23)])).
car(10, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("4715MJM"), "year" - i(2005), "month" - i(2), "day" - i(23), "hour" - i(21), "minute" - i(36), "station" - s("pilot"), "fill-ups" - i(50), "record history (days)" - i(160), "weekdays" - i(33), "weekends" - i(17), "preferred day" - s("tuesday"), "day preference %" - i(24), "mean time of visit (minutes after midnight)" - i(28), "standard deviation from mean" - i(192), "different locations" - i(3), "preferred station" - s("mobil"), "preferred station %" - i(86), "% pay cashier (instead of at pump)" - i(6), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(44)])).
car(11, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("9CNI705"), "year" - i(2005), "month" - i(3), "day" - i(3), "hour" - i(23), "minute" - i(48), "station" - s("mobil"), "fill-ups" - i(22), "record history (days)" - i(168), "weekdays" - i(12), "weekends" - i(10), "preferred day" - s("sunday"), "day preference %" - i(27), "mean time of visit (minutes after midnight)" - i(53), "standard deviation from mean" - i(240), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(90), "% pay cashier (instead of at pump)" - i(9), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(31)])).
car(12, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("4BNI905"), "year" - i(2005), "month" - i(2), "day" - i(6), "hour" - i(16), "minute" - i(25), "station" - s("mobil"), "fill-ups" - i(25), "record history (days)" - i(143), "weekdays" - i(10), "weekends" - i(15), "preferred day" - s("sunday"), "day preference %" - i(56), "mean time of visit (minutes after midnight)" - i(46), "standard deviation from mean" - i(216), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(84), "% pay cashier (instead of at pump)" - i(8), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(60)])).
car(13, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("8XNI025"), "year" - i(2005), "month" - i(1), "day" - i(23), "hour" - i(18), "minute" - i(57), "station" - s("mobil"), "fill-ups" - i(28), "record history (days)" - i(146), "weekdays" - i(22), "weekends" - i(6), "preferred day" - s("monday"), "day preference %" - i(32), "mean time of visit (minutes after midnight)" - i(22), "standard deviation from mean" - i(107), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(8), "payment method" - s("credit"), "preferred pump" - s("27HG"), "preferred pump %" - i(35)])).
car(14, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("2TNI107"), "year" - i(2005), "month" - i(2), "day" - i(26), "hour" - i(21), "minute" - i(2), "station" - s("mobil"), "fill-ups" - i(36), "record history (days)" - i(141), "weekdays" - i(22), "weekends" - i(14), "preferred day" - s("saturday"), "day preference %" - i(25), "mean time of visit (minutes after midnight)" - i(25), "standard deviation from mean" - i(149), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(5), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(55)])).
car(15, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("4ZNI107"), "year" - i(2005), "month" - i(1), "day" - i(23), "hour" - i(11), "minute" - i(40), "station" - s("shell"), "fill-ups" - i(18), "record history (days)" - i(146), "weekdays" - i(10), "weekends" - i(8), "preferred day" - s("sunday"), "day preference %" - i(27), "mean time of visit (minutes after midnight)" - i(53), "standard deviation from mean" - i(216), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(83), "% pay cashier (instead of at pump)" - i(5), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(27)])).
car(16, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("3UNI917"), "year" - i(2005), "month" - i(2), "day" - i(6), "hour" - i(13), "minute" - i(46), "station" - s("mobil"), "fill-ups" - i(22), "record history (days)" - i(139), "weekdays" - i(16), "weekends" - i(6), "preferred day" - s("thursday"), "day preference %" - i(22), "mean time of visit (minutes after midnight)" - i(54), "standard deviation from mean" - i(237), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(95), "% pay cashier (instead of at pump)" - i(9), "payment method" - s("credit"), "preferred pump" - s("37HG"), "preferred pump %" - i(31)])).
car(17, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("7SNI617"), "year" - i(2005), "month" - i(2), "day" - i(26), "hour" - i(22), "minute" - i(53), "station" - s("mobil"), "fill-ups" - i(9), "record history (days)" - i(141), "weekdays" - i(7), "weekends" - i(2), "preferred day" - s("friday"), "day preference %" - i(33), "mean time of visit (minutes after midnight)" - i(232), "standard deviation from mean" - i(476), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(88), "% pay cashier (instead of at pump)" - i(16), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(55)])).
car(18, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("4BNI973"), "year" - i(2005), "month" - i(2), "day" - i(12), "hour" - i(12), "minute" - i(15), "station" - s("mobil"), "fill-ups" - i(75), "record history (days)" - i(148), "weekdays" - i(59), "weekends" - i(16), "preferred day" - s("wednesday"), "day preference %" - i(20), "mean time of visit (minutes after midnight)" - i(11), "standard deviation from mean" - i(94), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(97), "% pay cashier (instead of at pump)" - i(5), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(30)])).
car(19, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("6SNI083"), "year" - i(2005), "month" - i(2), "day" - i(10), "hour" - i(20), "minute" - i(27), "station" - s("mobil"), "fill-ups" - i(22), "record history (days)" - i(170), "weekdays" - i(19), "weekends" - i(3), "preferred day" - s("wednesday"), "day preference %" - i(31), "mean time of visit (minutes after midnight)" - i(64), "standard deviation from mean" - i(281), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(95), "% pay cashier (instead of at pump)" - i(14), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(27)])).
car(20, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("4ZNI568"), "year" - i(2005), "month" - i(2), "day" - i(28), "hour" - i(8), "minute" - i(27), "station" - s("mobil"), "fill-ups" - i(75), "record history (days)" - i(162), "weekdays" - i(48), "weekends" - i(27), "preferred day" - s("monday"), "day preference %" - i(24), "mean time of visit (minutes after midnight)" - i(7), "standard deviation from mean" - i(63), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(5), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(34)])).
car(21, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("7SNI074"), "year" - i(2005), "month" - i(3), "day" - i(1), "hour" - i(19), "minute" - i(0), "station" - s("mobil"), "fill-ups" - i(46), "record history (days)" - i(146), "weekdays" - i(30), "weekends" - i(16), "preferred day" - s("monday"), "day preference %" - i(21), "mean time of visit (minutes after midnight)" - i(27), "standard deviation from mean" - i(179), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(89), "% pay cashier (instead of at pump)" - i(4), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(69)])).
car(22, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("2095NJM"), "year" - i(2005), "month" - i(2), "day" - i(28), "hour" - i(15), "minute" - i(49), "station" - s("mobil"), "fill-ups" - i(44), "record history (days)" - i(142), "weekdays" - i(35), "weekends" - i(9), "preferred day" - s("monday"), "day preference %" - i(29), "mean time of visit (minutes after midnight)" - i(28), "standard deviation from mean" - i(182), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(86), "% pay cashier (instead of at pump)" - i(6), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(22)])).
car(23, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("21387AH"), "year" - i(2004), "month" - i(10), "day" - i(12), "hour" - i(17), "minute" - i(2), "station" - s("mobil"), "fill-ups" - i(4), "record history (days)" - i(47), "weekdays" - i(4), "weekends" - i(0), "preferred day" - s("monday"), "day preference %" - i(50), "mean time of visit (minutes after midnight)" - i(325), "standard deviation from mean" - i(376), "different locations" - i(3), "preferred station" - s("Cumberland Farms"), "preferred station %" - i(50), "% pay cashier (instead of at pump)" - i(33), "payment method" - s("credit"), "preferred pump" - s("54VH"), "preferred pump %" - i(25)])).
car(24, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("6SNI473"), "year" - i(2005), "month" - i(1), "day" - i(16), "hour" - i(0), "minute" - i(53), "station" - s("mobil"), "fill-ups" - i(9), "record history (days)" - i(134), "weekdays" - i(6), "weekends" - i(3), "preferred day" - s("thursday"), "day preference %" - i(33), "mean time of visit (minutes after midnight)" - i(151), "standard deviation from mean" - i(375), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(25), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(33)])).
car(25, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("4BNI217"), "year" - i(2005), "month" - i(2), "day" - i(20), "hour" - i(15), "minute" - i(29), "station" - s("mobil"), "fill-ups" - i(51), "record history (days)" - i(151), "weekdays" - i(28), "weekends" - i(23), "preferred day" - s("saturday"), "day preference %" - i(27), "mean time of visit (minutes after midnight)" - i(14), "standard deviation from mean" - i(101), "different locations" - i(3), "preferred station" - s("mobil"), "preferred station %" - i(92), "% pay cashier (instead of at pump)" - i(6), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(25)])).
car(26, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("9ZNI923"), "year" - i(2005), "month" - i(2), "day" - i(5), "hour" - i(9), "minute" - i(5), "station" - s("shell"), "fill-ups" - i(26), "record history (days)" - i(142), "weekdays" - i(10), "weekends" - i(16), "preferred day" - s("sunday"), "day preference %" - i(30), "mean time of visit (minutes after midnight)" - i(23), "standard deviation from mean" - i(117), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(65), "% pay cashier (instead of at pump)" - i(3), "payment method" - s("credit"), "preferred pump" - s("27LG"), "preferred pump %" - i(30)])).
car(27, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("8CNI123"), "year" - i(2005), "month" - i(2), "day" - i(1), "hour" - i(10), "minute" - i(51), "station" - s("shell"), "fill-ups" - i(26), "record history (days)" - i(147), "weekdays" - i(19), "weekends" - i(7), "preferred day" - s("wednesday"), "day preference %" - i(19), "mean time of visit (minutes after midnight)" - i(34), "standard deviation from mean" - i(162), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(80), "% pay cashier (instead of at pump)" - i(8), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(26)])).
car(28, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("2CNI467"), "year" - i(2005), "month" - i(2), "day" - i(1), "hour" - i(14), "minute" - i(21), "station" - s("mobil"), "fill-ups" - i(14), "record history (days)" - i(135), "weekdays" - i(9), "weekends" - i(5), "preferred day" - s("sunday"), "day preference %" - i(28), "mean time of visit (minutes after midnight)" - i(57), "standard deviation from mean" - i(198), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(78), "% pay cashier (instead of at pump)" - i(7), "payment method" - s("credit"), "preferred pump" - s("27HG"), "preferred pump %" - i(28)])).
car(29, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("34279AH"), "year" - i(2005), "month" - i(3), "day" - i(3), "hour" - i(21), "minute" - i(49), "station" - s("mobil"), "fill-ups" - i(45), "record history (days)" - i(170), "weekdays" - i(33), "weekends" - i(12), "preferred day" - s("friday"), "day preference %" - i(22), "mean time of visit (minutes after midnight)" - i(1), "standard deviation from mean" - i(13), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(82), "% pay cashier (instead of at pump)" - i(4), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(22)])).
car(30, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("7TNI889"), "year" - i(2004), "month" - i(11), "day" - i(1), "hour" - i(9), "minute" - i(37), "station" - s("mobil"), "fill-ups" - i(57), "record history (days)" - i(152), "weekdays" - i(50), "weekends" - i(7), "preferred day" - s("wednesday"), "day preference %" - i(24), "mean time of visit (minutes after midnight)" - i(1), "standard deviation from mean" - i(12), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(94), "% pay cashier (instead of at pump)" - i(5), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(42)])).
car(31, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("6SNI432"), "year" - i(2005), "month" - i(1), "day" - i(11), "hour" - i(19), "minute" - i(43), "station" - s("mobil"), "fill-ups" - i(32), "record history (days)" - i(147), "weekdays" - i(29), "weekends" - i(3), "preferred day" - s("friday"), "day preference %" - i(25), "mean time of visit (minutes after midnight)" - i(43), "standard deviation from mean" - i(239), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(6), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(100)])).
car(32, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("8ENI110"), "year" - i(2005), "month" - i(2), "day" - i(28), "hour" - i(23), "minute" - i(58), "station" - s("mobil"), "fill-ups" - i(51), "record history (days)" - i(142), "weekdays" - i(43), "weekends" - i(8), "preferred day" - s("wednesday"), "day preference %" - i(21), "mean time of visit (minutes after midnight)" - i(0), "standard deviation from mean" - i(1), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(96), "% pay cashier (instead of at pump)" - i(6), "payment method" - s("credit"), "preferred pump" - s("47HG"), "preferred pump %" - i(33)])).
car(33, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("3XNI510"), "year" - i(2004), "month" - i(12), "day" - i(23), "hour" - i(12), "minute" - i(37), "station" - s("mobil"), "fill-ups" - i(15), "record history (days)" - i(136), "weekdays" - i(7), "weekends" - i(8), "preferred day" - s("sunday"), "day preference %" - i(53), "mean time of visit (minutes after midnight)" - i(76), "standard deviation from mean" - i(276), "different locations" - i(2), "preferred station" - s("shell"), "preferred station %" - i(86), "% pay cashier (instead of at pump)" - i(13), "payment method" - s("credit"), "preferred pump" - s("17LG"), "preferred pump %" - i(33)])).
car(34, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("2WNI720"), "year" - i(2005), "month" - i(2), "day" - i(23), "hour" - i(11), "minute" - i(32), "station" - s("shell"), "fill-ups" - i(69), "record history (days)" - i(157), "weekdays" - i(55), "weekends" - i(14), "preferred day" - s("thursday"), "day preference %" - i(23), "mean time of visit (minutes after midnight)" - i(20), "standard deviation from mean" - i(161), "different locations" - i(3), "preferred station" - s("mobil"), "preferred station %" - i(92), "% pay cashier (instead of at pump)" - i(4), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(23)])).
car(35, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("3XNI132"), "year" - i(2005), "month" - i(2), "day" - i(20), "hour" - i(16), "minute" - i(45), "station" - s("shell"), "fill-ups" - i(18), "record history (days)" - i(147), "weekdays" - i(8), "weekends" - i(10), "preferred day" - s("sunday"), "day preference %" - i(27), "mean time of visit (minutes after midnight)" - i(64), "standard deviation from mean" - i(259), "different locations" - i(2), "preferred station" - s("shell"), "preferred station %" - i(72), "% pay cashier (instead of at pump)" - i(11), "payment method" - s("credit"), "preferred pump" - s("27LG"), "preferred pump %" - i(27)])).
car(36, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("2XNI232"), "year" - i(2005), "month" - i(2), "day" - i(26), "hour" - i(22), "minute" - i(12), "station" - s("mobil"), "fill-ups" - i(37), "record history (days)" - i(152), "weekdays" - i(27), "weekends" - i(10), "preferred day" - s("monday"), "day preference %" - i(18), "mean time of visit (minutes after midnight)" - i(21), "standard deviation from mean" - i(125), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(83), "% pay cashier (instead of at pump)" - i(8), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(32)])).
car(37, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("0BNI942"), "year" - i(2005), "month" - i(2), "day" - i(9), "hour" - i(9), "minute" - i(22), "station" - s("mobil"), "fill-ups" - i(31), "record history (days)" - i(139), "weekdays" - i(26), "weekends" - i(5), "preferred day" - s("wednesday"), "day preference %" - i(22), "mean time of visit (minutes after midnight)" - i(43), "standard deviation from mean" - i(234), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(96), "% pay cashier (instead of at pump)" - i(6), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(19)])).
car(38, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("0ZNI364"), "year" - i(2005), "month" - i(2), "day" - i(9), "hour" - i(9), "minute" - i(40), "station" - s("mobil"), "fill-ups" - i(81), "record history (days)" - i(148), "weekdays" - i(64), "weekends" - i(17), "preferred day" - s("monday"), "day preference %" - i(17), "mean time of visit (minutes after midnight)" - i(7), "standard deviation from mean" - i(65), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(90), "% pay cashier (instead of at pump)" - i(5), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(43)])).
car(39, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("91698AH"), "year" - i(2004), "month" - i(10), "day" - i(6), "hour" - i(13), "minute" - i(8), "station" - s("shell"), "fill-ups" - i(3), "record history (days)" - i(24), "weekdays" - i(3), "weekends" - i(0), "preferred day" - s("thursday"), "day preference %" - i(100), "mean time of visit (minutes after midnight)" - i(367), "standard deviation from mean" - i(424), "different locations" - i(2), "preferred station" - s("shell"), "preferred station %" - i(66), "% pay cashier (instead of at pump)" - i(66), "payment method" - s("credit"), "preferred pump" - s("97LG"), "preferred pump %" - i(66)])).
car(40, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("86778AH"), "year" - i(2005), "month" - i(1), "day" - i(30), "hour" - i(13), "minute" - i(27), "station" - s("mobil"), "fill-ups" - i(114), "record history (days)" - i(148), "weekdays" - i(88), "weekends" - i(26), "preferred day" - s("friday"), "day preference %" - i(27), "mean time of visit (minutes after midnight)" - i(4), "standard deviation from mean" - i(52), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(65), "% pay cashier (instead of at pump)" - i(3), "payment method" - s("credit"), "preferred pump" - s("27LG"), "preferred pump %" - i(21)])).
car(41, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("53289AH"), "year" - i(2004), "month" - i(12), "day" - i(17), "hour" - i(7), "minute" - i(29), "station" - s("mobil"), "fill-ups" - i(64), "record history (days)" - i(144), "weekdays" - i(47), "weekends" - i(17), "preferred day" - s("friday"), "day preference %" - i(23), "mean time of visit (minutes after midnight)" - i(7), "standard deviation from mean" - i(60), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(96), "% pay cashier (instead of at pump)" - i(7), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(40)])).
car(42, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("77199AH"), "year" - i(2004), "month" - i(12), "day" - i(22), "hour" - i(9), "minute" - i(45), "station" - s("mobil"), "fill-ups" - i(54), "record history (days)" - i(147), "weekdays" - i(41), "weekends" - i(13), "preferred day" - s("friday"), "day preference %" - i(20), "mean time of visit (minutes after midnight)" - i(11), "standard deviation from mean" - i(77), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(64), "% pay cashier (instead of at pump)" - i(3), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(29)])).
car(43, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("58609AH"), "year" - i(2005), "month" - i(3), "day" - i(1), "hour" - i(22), "minute" - i(42), "station" - s("shell"), "fill-ups" - i(8), "record history (days)" - i(142), "weekdays" - i(8), "weekends" - i(0), "preferred day" - s("tuesday"), "day preference %" - i(37), "mean time of visit (minutes after midnight)" - i(0), "standard deviation from mean" - i(1), "different locations" - i(2), "preferred station" - s("shell"), "preferred station %" - i(62), "% pay cashier (instead of at pump)" - i(12), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(37)])).
car(44, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("2UNI147"), "year" - i(2005), "month" - i(2), "day" - i(26), "hour" - i(19), "minute" - i(21), "station" - s("mobil"), "fill-ups" - i(8), "record history (days)" - i(81), "weekdays" - i(5), "weekends" - i(3), "preferred day" - s("tuesday"), "day preference %" - i(37), "mean time of visit (minutes after midnight)" - i(85), "standard deviation from mean" - i(212), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(12), "payment method" - s("credit"), "preferred pump" - s("47HG"), "preferred pump %" - i(37)])).
car(45, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("9ZNI893"), "year" - i(2005), "month" - i(1), "day" - i(7), "hour" - i(12), "minute" - i(43), "station" - s("mobil"), "fill-ups" - i(102), "record history (days)" - i(141), "weekdays" - i(85), "weekends" - i(17), "preferred day" - s("thursday"), "day preference %" - i(22), "mean time of visit (minutes after midnight)" - i(8), "standard deviation from mean" - i(81), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(97), "% pay cashier (instead of at pump)" - i(4), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(29)])).
car(46, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("8XNI993"), "year" - i(2004), "month" - i(12), "day" - i(4), "hour" - i(14), "minute" - i(46), "station" - s("mobil"), "fill-ups" - i(56), "record history (days)" - i(149), "weekdays" - i(45), "weekends" - i(11), "preferred day" - s("tuesday"), "day preference %" - i(26), "mean time of visit (minutes after midnight)" - i(9), "standard deviation from mean" - i(69), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(75), "% pay cashier (instead of at pump)" - i(5), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(19)])).
car(47, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("2DNI093"), "year" - i(2005), "month" - i(1), "day" - i(22), "hour" - i(17), "minute" - i(10), "station" - s("mobil"), "fill-ups" - i(19), "record history (days)" - i(143), "weekdays" - i(14), "weekends" - i(5), "preferred day" - s("saturday"), "day preference %" - i(26), "mean time of visit (minutes after midnight)" - i(55), "standard deviation from mean" - i(228), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(10), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(63)])).
car(48, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("7SNI493"), "year" - i(2005), "month" - i(2), "day" - i(6), "hour" - i(11), "minute" - i(42), "station" - s("mobil"), "fill-ups" - i(27), "record history (days)" - i(143), "weekdays" - i(16), "weekends" - i(11), "preferred day" - s("wednesday"), "day preference %" - i(25), "mean time of visit (minutes after midnight)" - i(38), "standard deviation from mean" - i(190), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(7), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(51)])).
car(49, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("8080AII"), "year" - i(2005), "month" - i(3), "day" - i(4), "hour" - i(10), "minute" - i(29), "station" - s("mobil"), "fill-ups" - i(52), "record history (days)" - i(168), "weekdays" - i(47), "weekends" - i(5), "preferred day" - s("tuesday"), "day preference %" - i(23), "mean time of visit (minutes after midnight)" - i(16), "standard deviation from mean" - i(114), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(65), "% pay cashier (instead of at pump)" - i(4), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(21)])).
car(50, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("84129DH"), "year" - i(2005), "month" - i(1), "day" - i(25), "hour" - i(12), "minute" - i(57), "station" - s("mobil"), "fill-ups" - i(194), "record history (days)" - i(132), "weekdays" - i(158), "weekends" - i(36), "preferred day" - s("tuesday"), "day preference %" - i(18), "mean time of visit (minutes after midnight)" - i(4), "standard deviation from mean" - i(66), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(51), "% pay cashier (instead of at pump)" - i(2), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(38)])).
car(51, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("3223YII"), "year" - i(2005), "month" - i(3), "day" - i(4), "hour" - i(9), "minute" - i(25), "station" - s("mobil"), "fill-ups" - i(160), "record history (days)" - i(172), "weekdays" - i(137), "weekends" - i(23), "preferred day" - s("thursday"), "day preference %" - i(20), "mean time of visit (minutes after midnight)" - i(4), "standard deviation from mean" - i(51), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(93), "% pay cashier (instead of at pump)" - i(3), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(23)])).
car(52, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("4435RHI"), "year" - i(2005), "month" - i(2), "day" - i(23), "hour" - i(16), "minute" - i(14), "station" - s("shell"), "fill-ups" - i(100), "record history (days)" - i(137), "weekdays" - i(88), "weekends" - i(12), "preferred day" - s("tuesday"), "day preference %" - i(21), "mean time of visit (minutes after midnight)" - i(10), "standard deviation from mean" - i(100), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(74), "% pay cashier (instead of at pump)" - i(3), "payment method" - s("credit"), "preferred pump" - s("37HG"), "preferred pump %" - i(22)])).
car(53, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("3716EHI"), "year" - i(2005), "month" - i(2), "day" - i(9), "hour" - i(17), "minute" - i(7), "station" - s("Cumberland Farms"), "fill-ups" - i(65), "record history (days)" - i(123), "weekdays" - i(53), "weekends" - i(12), "preferred day" - s("tuesday"), "day preference %" - i(20), "mean time of visit (minutes after midnight)" - i(18), "standard deviation from mean" - i(146), "different locations" - i(4), "preferred station" - s("shell"), "preferred station %" - i(47), "% pay cashier (instead of at pump)" - i(6), "payment method" - s("credit"), "preferred pump" - s("07LG"), "preferred pump %" - i(21)])).
car(54, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("6DNI445"), "year" - i(2005), "month" - i(3), "day" - i(1), "hour" - i(15), "minute" - i(18), "station" - s("shell"), "fill-ups" - i(17), "record history (days)" - i(168), "weekdays" - i(15), "weekends" - i(2), "preferred day" - s("thursday"), "day preference %" - i(29), "mean time of visit (minutes after midnight)" - i(63), "standard deviation from mean" - i(236), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(64), "% pay cashier (instead of at pump)" - i(6), "payment method" - s("credit"), "preferred pump" - s("97LG"), "preferred pump %" - i(23)])).
car(55, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("2DNI955"), "year" - i(2004), "month" - i(11), "day" - i(12), "hour" - i(12), "minute" - i(37), "station" - s("shell"), "fill-ups" - i(27), "record history (days)" - i(146), "weekdays" - i(18), "weekends" - i(9), "preferred day" - s("saturday"), "day preference %" - i(22), "mean time of visit (minutes after midnight)" - i(39), "standard deviation from mean" - i(198), "different locations" - i(2), "preferred station" - s("shell"), "preferred station %" - i(51), "% pay cashier (instead of at pump)" - i(7), "payment method" - s("credit"), "preferred pump" - s("97LG"), "preferred pump %" - i(25)])).
car(56, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("2133BHI"), "year" - i(2005), "month" - i(2), "day" - i(23), "hour" - i(14), "minute" - i(5), "station" - s("shell"), "fill-ups" - i(77), "record history (days)" - i(160), "weekdays" - i(72), "weekends" - i(5), "preferred day" - s("tuesday"), "day preference %" - i(22), "mean time of visit (minutes after midnight)" - i(9), "standard deviation from mean" - i(85), "different locations" - i(2), "preferred station" - s("shell"), "preferred station %" - i(84), "% pay cashier (instead of at pump)" - i(5), "payment method" - s("credit"), "preferred pump" - s("27LG"), "preferred pump %" - i(28)])).
car(57, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("2ZMX575"), "year" - i(2005), "month" - i(2), "day" - i(9), "hour" - i(22), "minute" - i(36), "station" - s("mobil"), "fill-ups" - i(2), "record history (days)" - i(52), "weekdays" - i(2), "weekends" - i(0), "preferred day" - s("wednesday"), "day preference %" - i(50), "mean time of visit (minutes after midnight)" - i(187), "standard deviation from mean" - i(133), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(50), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(100)])).
car(58, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("0ZNI516"), "year" - i(2005), "month" - i(3), "day" - i(2), "hour" - i(20), "minute" - i(30), "station" - s("mobil"), "fill-ups" - i(49), "record history (days)" - i(147), "weekdays" - i(38), "weekends" - i(11), "preferred day" - s("friday"), "day preference %" - i(32), "mean time of visit (minutes after midnight)" - i(27), "standard deviation from mean" - i(182), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(77), "% pay cashier (instead of at pump)" - i(6), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(28)])).
car(59, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("3546UII"), "year" - i(2005), "month" - i(1), "day" - i(2), "hour" - i(20), "minute" - i(33), "station" - s("mobil"), "fill-ups" - i(7), "record history (days)" - i(147), "weekdays" - i(5), "weekends" - i(2), "preferred day" - s("tuesday"), "day preference %" - i(28), "mean time of visit (minutes after midnight)" - i(145), "standard deviation from mean" - i(331), "different locations" - i(3), "preferred station" - s("racetrac"), "preferred station %" - i(42), "% pay cashier (instead of at pump)" - i(14), "payment method" - s("credit"), "preferred pump" - s("97PX"), "preferred pump %" - i(42)])).
car(60, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("90734BH"), "year" - i(2005), "month" - i(2), "day" - i(16), "hour" - i(15), "minute" - i(23), "station" - s("mobil"), "fill-ups" - i(72), "record history (days)" - i(138), "weekdays" - i(58), "weekends" - i(14), "preferred day" - s("tuesday"), "day preference %" - i(18), "mean time of visit (minutes after midnight)" - i(15), "standard deviation from mean" - i(126), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(75), "% pay cashier (instead of at pump)" - i(4), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(41)])).
car(61, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("5VNI949"), "year" - i(2005), "month" - i(2), "day" - i(7), "hour" - i(21), "minute" - i(16), "station" - s("mobil"), "fill-ups" - i(12), "record history (days)" - i(122), "weekdays" - i(11), "weekends" - i(1), "preferred day" - s("monday"), "day preference %" - i(41), "mean time of visit (minutes after midnight)" - i(91), "standard deviation from mean" - i(289), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(8), "payment method" - s("credit"), "preferred pump" - s("27HG"), "preferred pump %" - i(25)])).
car(62, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("7VNI906"), "year" - i(2005), "month" - i(2), "day" - i(6), "hour" - i(11), "minute" - i(17), "station" - s("mobil"), "fill-ups" - i(43), "record history (days)" - i(148), "weekdays" - i(28), "weekends" - i(15), "preferred day" - s("sunday"), "day preference %" - i(25), "mean time of visit (minutes after midnight)" - i(25), "standard deviation from mean" - i(160), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(74), "% pay cashier (instead of at pump)" - i(5), "payment method" - s("credit"), "preferred pump" - s("47HG"), "preferred pump %" - i(23)])).
car(63, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("5DNI006"), "year" - i(2005), "month" - i(1), "day" - i(30), "hour" - i(11), "minute" - i(12), "station" - s("mobil"), "fill-ups" - i(8), "record history (days)" - i(136), "weekdays" - i(2), "weekends" - i(6), "preferred day" - s("sunday"), "day preference %" - i(62), "mean time of visit (minutes after midnight)" - i(106), "standard deviation from mean" - i(265), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(25), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(100)])).
car(64, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("3WNI306"), "year" - i(2005), "month" - i(2), "day" - i(27), "hour" - i(19), "minute" - i(20), "station" - s("mobil"), "fill-ups" - i(34), "record history (days)" - i(162), "weekdays" - i(26), "weekends" - i(8), "preferred day" - s("tuesday"), "day preference %" - i(23), "mean time of visit (minutes after midnight)" - i(39), "standard deviation from mean" - i(214), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(97), "% pay cashier (instead of at pump)" - i(6), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(55)])).
car(65, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("6XNI606"), "year" - i(2005), "month" - i(2), "day" - i(21), "hour" - i(1), "minute" - i(20), "station" - s("mobil"), "fill-ups" - i(22), "record history (days)" - i(157), "weekdays" - i(15), "weekends" - i(7), "preferred day" - s("monday"), "day preference %" - i(27), "mean time of visit (minutes after midnight)" - i(58), "standard deviation from mean" - i(264), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(13), "payment method" - s("credit"), "preferred pump" - s("47HG"), "preferred pump %" - i(31)])).
car(66, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("9CNI816"), "year" - i(2005), "month" - i(2), "day" - i(25), "hour" - i(16), "minute" - i(14), "station" - s("mobil"), "fill-ups" - i(39), "record history (days)" - i(155), "weekdays" - i(29), "weekends" - i(10), "preferred day" - s("saturday"), "day preference %" - i(20), "mean time of visit (minutes after midnight)" - i(1), "standard deviation from mean" - i(11), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(94), "% pay cashier (instead of at pump)" - i(7), "payment method" - s("credit"), "preferred pump" - s("37HG"), "preferred pump %" - i(20)])).
car(67, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("2376HHI"), "year" - i(2005), "month" - i(2), "day" - i(17), "hour" - i(10), "minute" - i(30), "station" - s("mobil"), "fill-ups" - i(82), "record history (days)" - i(154), "weekdays" - i(62), "weekends" - i(20), "preferred day" - s("tuesday"), "day preference %" - i(23), "mean time of visit (minutes after midnight)" - i(11), "standard deviation from mean" - i(94), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(6), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(21)])).
car(68, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("9805RHI"), "year" - i(2005), "month" - i(2), "day" - i(14), "hour" - i(0), "minute" - i(22), "station" - s("mobil"), "fill-ups" - i(49), "record history (days)" - i(148), "weekdays" - i(38), "weekends" - i(11), "preferred day" - s("wednesday"), "day preference %" - i(22), "mean time of visit (minutes after midnight)" - i(17), "standard deviation from mean" - i(121), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(69), "% pay cashier (instead of at pump)" - i(6), "payment method" - s("credit"), "preferred pump" - s("47HG"), "preferred pump %" - i(20)])).
car(69, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("2DNI238"), "year" - i(2005), "month" - i(3), "day" - i(1), "hour" - i(11), "minute" - i(14), "station" - s("shell"), "fill-ups" - i(24), "record history (days)" - i(139), "weekdays" - i(21), "weekends" - i(3), "preferred day" - s("tuesday"), "day preference %" - i(25), "mean time of visit (minutes after midnight)" - i(31), "standard deviation from mean" - i(149), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(75), "% pay cashier (instead of at pump)" - i(4), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(25)])).
car(70, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("6028DA"), "year" - i(2005), "month" - i(1), "day" - i(14), "hour" - i(22), "minute" - i(0), "station" - s("amoco"), "fill-ups" - i(9), "record history (days)" - i(129), "weekdays" - i(7), "weekends" - i(2), "preferred day" - s("thursday"), "day preference %" - i(33), "mean time of visit (minutes after midnight)" - i(149), "standard deviation from mean" - i(399), "different locations" - i(4), "preferred station" - s("amoco"), "preferred station %" - i(44), "% pay cashier (instead of at pump)" - i(22), "payment method" - s("credit"), "preferred pump" - s("77VM"), "preferred pump %" - i(11)])).
car(71, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("0TNI109"), "year" - i(2005), "month" - i(3), "day" - i(3), "hour" - i(18), "minute" - i(52), "station" - s("mobil"), "fill-ups" - i(51), "record history (days)" - i(148), "weekdays" - i(34), "weekends" - i(17), "preferred day" - s("thursday"), "day preference %" - i(23), "mean time of visit (minutes after midnight)" - i(0), "standard deviation from mean" - i(1), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(64), "% pay cashier (instead of at pump)" - i(4), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(19)])).
car(72, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("0WNI309"), "year" - i(2005), "month" - i(2), "day" - i(1), "hour" - i(19), "minute" - i(8), "station" - s("mobil"), "fill-ups" - i(22), "record history (days)" - i(148), "weekdays" - i(18), "weekends" - i(4), "preferred day" - s("monday"), "day preference %" - i(27), "mean time of visit (minutes after midnight)" - i(59), "standard deviation from mean" - i(259), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(95), "% pay cashier (instead of at pump)" - i(9), "payment method" - s("credit"), "preferred pump" - s("37HG"), "preferred pump %" - i(27)])).
car(73, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("2117OJM"), "year" - i(2005), "month" - i(3), "day" - i(4), "hour" - i(13), "minute" - i(53), "station" - s("mobil"), "fill-ups" - i(6), "record history (days)" - i(25), "weekdays" - i(6), "weekends" - i(0), "preferred day" - s("tuesday"), "day preference %" - i(50), "mean time of visit (minutes after midnight)" - i(220), "standard deviation from mean" - i(450), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(83), "% pay cashier (instead of at pump)" - i(33), "payment method" - s("credit"), "preferred pump" - s("37HG"), "preferred pump %" - i(33)])).
car(74, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("7JNI640"), "year" - i(2005), "month" - i(3), "day" - i(3), "hour" - i(12), "minute" - i(34), "station" - s("mobil"), "fill-ups" - i(14), "record history (days)" - i(34), "weekdays" - i(12), "weekends" - i(2), "preferred day" - s("monday"), "day preference %" - i(28), "mean time of visit (minutes after midnight)" - i(54), "standard deviation from mean" - i(190), "different locations" - i(2), "preferred station" - s("shell"), "preferred station %" - i(78), "% pay cashier (instead of at pump)" - i(7), "payment method" - s("credit"), "preferred pump" - s("97LG"), "preferred pump %" - i(35)])).
car(75, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("5650RII"), "year" - i(2005), "month" - i(2), "day" - i(18), "hour" - i(14), "minute" - i(17), "station" - s("shell"), "fill-ups" - i(11), "record history (days)" - i(125), "weekdays" - i(8), "weekends" - i(3), "preferred day" - s("friday"), "day preference %" - i(45), "mean time of visit (minutes after midnight)" - i(86), "standard deviation from mean" - i(262), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(63), "% pay cashier (instead of at pump)" - i(9), "payment method" - s("credit"), "preferred pump" - s("47HG"), "preferred pump %" - i(36)])).
car(76, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("7SNI224"), "year" - i(2005), "month" - i(2), "day" - i(27), "hour" - i(13), "minute" - i(39), "station" - s("mobil"), "fill-ups" - i(13), "record history (days)" - i(157), "weekdays" - i(8), "weekends" - i(5), "preferred day" - s("thursday"), "day preference %" - i(23), "mean time of visit (minutes after midnight)" - i(104), "standard deviation from mean" - i(348), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(92), "% pay cashier (instead of at pump)" - i(15), "payment method" - s("credit"), "preferred pump" - s("37HG"), "preferred pump %" - i(38)])).
car(77, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("3560AII"), "year" - i(2005), "month" - i(3), "day" - i(3), "hour" - i(16), "minute" - i(58), "station" - s("mobil"), "fill-ups" - i(141), "record history (days)" - i(171), "weekdays" - i(122), "weekends" - i(19), "preferred day" - s("friday"), "day preference %" - i(19), "mean time of visit (minutes after midnight)" - i(4), "standard deviation from mean" - i(47), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(94), "% pay cashier (instead of at pump)" - i(3), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(31)])).
car(78, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("5SNI658"), "year" - i(2005), "month" - i(2), "day" - i(27), "hour" - i(17), "minute" - i(25), "station" - s("mobil"), "fill-ups" - i(45), "record history (days)" - i(155), "weekdays" - i(23), "weekends" - i(22), "preferred day" - s("sunday"), "day preference %" - i(26), "mean time of visit (minutes after midnight)" - i(24), "standard deviation from mean" - i(151), "different locations" - i(3), "preferred station" - s("mobil"), "preferred station %" - i(93), "% pay cashier (instead of at pump)" - i(7), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(55)])).
car(79, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("7XNI120"), "year" - i(2005), "month" - i(3), "day" - i(3), "hour" - i(15), "minute" - i(21), "station" - s("mobil"), "fill-ups" - i(25), "record history (days)" - i(170), "weekdays" - i(18), "weekends" - i(7), "preferred day" - s("tuesday"), "day preference %" - i(16), "mean time of visit (minutes after midnight)" - i(55), "standard deviation from mean" - i(262), "different locations" - i(3), "preferred station" - s("mobil"), "preferred station %" - i(72), "% pay cashier (instead of at pump)" - i(8), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(16)])).
car(80, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("8CNI601"), "year" - i(2005), "month" - i(1), "day" - i(27), "hour" - i(11), "minute" - i(22), "station" - s("mobil"), "fill-ups" - i(56), "record history (days)" - i(146), "weekdays" - i(49), "weekends" - i(7), "preferred day" - s("tuesday"), "day preference %" - i(25), "mean time of visit (minutes after midnight)" - i(20), "standard deviation from mean" - i(144), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(92), "% pay cashier (instead of at pump)" - i(9), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(28)])).
car(81, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("6CNI401"), "year" - i(2005), "month" - i(3), "day" - i(3), "hour" - i(3), "minute" - i(16), "station" - s("mobil"), "fill-ups" - i(113), "record history (days)" - i(148), "weekdays" - i(79), "weekends" - i(34), "preferred day" - s("thursday"), "day preference %" - i(20), "mean time of visit (minutes after midnight)" - i(1), "standard deviation from mean" - i(12), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(95), "% pay cashier (instead of at pump)" - i(3), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(38)])).
car(82, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("7393EII"), "year" - i(2005), "month" - i(2), "day" - i(18), "hour" - i(21), "minute" - i(25), "station" - s("mobil"), "fill-ups" - i(6), "record history (days)" - i(21), "weekdays" - i(4), "weekends" - i(2), "preferred day" - s("friday"), "day preference %" - i(50), "mean time of visit (minutes after midnight)" - i(214), "standard deviation from mean" - i(438), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(16), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(33)])).
car(83, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("3WNI865"), "year" - i(2005), "month" - i(3), "day" - i(1), "hour" - i(23), "minute" - i(48), "station" - s("mobil"), "fill-ups" - i(89), "record history (days)" - i(147), "weekdays" - i(64), "weekends" - i(25), "preferred day" - s("thursday"), "day preference %" - i(17), "mean time of visit (minutes after midnight)" - i(16), "standard deviation from mean" - i(146), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(93), "% pay cashier (instead of at pump)" - i(3), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(33)])).
car(84, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("2DNI565"), "year" - i(2005), "month" - i(3), "day" - i(3), "hour" - i(21), "minute" - i(3), "station" - s("mobil"), "fill-ups" - i(59), "record history (days)" - i(172), "weekdays" - i(39), "weekends" - i(20), "preferred day" - s("thursday"), "day preference %" - i(23), "mean time of visit (minutes after midnight)" - i(22), "standard deviation from mean" - i(171), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(94), "% pay cashier (instead of at pump)" - i(5), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(42)])).
car(85, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("0YNI375"), "year" - i(2005), "month" - i(2), "day" - i(26), "hour" - i(0), "minute" - i(52), "station" - s("mobil"), "fill-ups" - i(36), "record history (days)" - i(139), "weekdays" - i(29), "weekends" - i(7), "preferred day" - s("tuesday"), "day preference %" - i(30), "mean time of visit (minutes after midnight)" - i(3), "standard deviation from mean" - i(21), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(97), "% pay cashier (instead of at pump)" - i(5), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(41)])).
car(86, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("0YNI795"), "year" - i(2005), "month" - i(1), "day" - i(16), "hour" - i(13), "minute" - i(11), "station" - s("shell"), "fill-ups" - i(122), "record history (days)" - i(148), "weekdays" - i(100), "weekends" - i(22), "preferred day" - s("friday"), "day preference %" - i(18), "mean time of visit (minutes after midnight)" - i(5), "standard deviation from mean" - i(59), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(98), "% pay cashier (instead of at pump)" - i(3), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(66)])).
car(87, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("2CNI395"), "year" - i(2004), "month" - i(11), "day" - i(22), "hour" - i(23), "minute" - i(56), "station" - s("mobil"), "fill-ups" - i(38), "record history (days)" - i(147), "weekdays" - i(27), "weekends" - i(11), "preferred day" - s("thursday"), "day preference %" - i(21), "mean time of visit (minutes after midnight)" - i(0), "standard deviation from mean" - i(4), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(84), "% pay cashier (instead of at pump)" - i(5), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(23)])).
car(88, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("9691WII"), "year" - i(2004), "month" - i(12), "day" - i(31), "hour" - i(22), "minute" - i(24), "station" - s("mobil"), "fill-ups" - i(13), "record history (days)" - i(102), "weekdays" - i(3), "weekends" - i(10), "preferred day" - s("saturday"), "day preference %" - i(46), "mean time of visit (minutes after midnight)" - i(91), "standard deviation from mean" - i(303), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(69), "% pay cashier (instead of at pump)" - i(15), "payment method" - s("credit"), "preferred pump" - s("27HG"), "preferred pump %" - i(38)])).
car(89, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("2CNI505"), "year" - i(2005), "month" - i(2), "day" - i(12), "hour" - i(7), "minute" - i(19), "station" - s("mobil"), "fill-ups" - i(33), "record history (days)" - i(144), "weekdays" - i(14), "weekends" - i(19), "preferred day" - s("saturday"), "day preference %" - i(33), "mean time of visit (minutes after midnight)" - i(15), "standard deviation from mean" - i(77), "different locations" - i(3), "preferred station" - s("mobil"), "preferred station %" - i(93), "% pay cashier (instead of at pump)" - i(7), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(42)])).
car(90, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("13719AH"), "year" - i(2004), "month" - i(9), "day" - i(17), "hour" - i(18), "minute" - i(39), "station" - s("mobil"), "fill-ups" - i(13), "record history (days)" - i(113), "weekdays" - i(12), "weekends" - i(1), "preferred day" - s("friday"), "day preference %" - i(38), "mean time of visit (minutes after midnight)" - i(72), "standard deviation from mean" - i(240), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(84), "% pay cashier (instead of at pump)" - i(23), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(61)])).
car(91, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("59789AH"), "year" - i(2005), "month" - i(3), "day" - i(3), "hour" - i(16), "minute" - i(37), "station" - s("mobil"), "fill-ups" - i(69), "record history (days)" - i(165), "weekdays" - i(40), "weekends" - i(29), "preferred day" - s("saturday"), "day preference %" - i(21), "mean time of visit (minutes after midnight)" - i(18), "standard deviation from mean" - i(148), "different locations" - i(2), "preferred station" - s("shell"), "preferred station %" - i(73), "% pay cashier (instead of at pump)" - i(5), "payment method" - s("credit"), "preferred pump" - s("27LG"), "preferred pump %" - i(33)])).
car(92, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("0227YHI"), "year" - i(2005), "month" - i(3), "day" - i(4), "hour" - i(11), "minute" - i(19), "station" - s("shell"), "fill-ups" - i(45), "record history (days)" - i(172), "weekdays" - i(42), "weekends" - i(3), "preferred day" - s("monday"), "day preference %" - i(24), "mean time of visit (minutes after midnight)" - i(19), "standard deviation from mean" - i(127), "different locations" - i(2), "preferred station" - s("shell"), "preferred station %" - i(84), "% pay cashier (instead of at pump)" - i(4), "payment method" - s("credit"), "preferred pump" - s("27LG"), "preferred pump %" - i(31)])).
car(93, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("7VNI735"), "year" - i(2005), "month" - i(3), "day" - i(4), "hour" - i(10), "minute" - i(20), "station" - s("mobil"), "fill-ups" - i(59), "record history (days)" - i(165), "weekdays" - i(54), "weekends" - i(5), "preferred day" - s("wednesday"), "day preference %" - i(28), "mean time of visit (minutes after midnight)" - i(22), "standard deviation from mean" - i(167), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(98), "% pay cashier (instead of at pump)" - i(7), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(33)])).
car(94, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("3BNI074"), "year" - i(2005), "month" - i(3), "day" - i(4), "hour" - i(10), "minute" - i(14), "station" - s("shell"), "fill-ups" - i(71), "record history (days)" - i(150), "weekdays" - i(66), "weekends" - i(5), "preferred day" - s("friday"), "day preference %" - i(22), "mean time of visit (minutes after midnight)" - i(18), "standard deviation from mean" - i(158), "different locations" - i(2), "preferred station" - s("shell"), "preferred station %" - i(83), "% pay cashier (instead of at pump)" - i(4), "payment method" - s("credit"), "preferred pump" - s("17LG"), "preferred pump %" - i(25)])).
car(95, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("8999VHI"), "year" - i(2005), "month" - i(3), "day" - i(3), "hour" - i(19), "minute" - i(5), "station" - s("shell"), "fill-ups" - i(32), "record history (days)" - i(172), "weekdays" - i(31), "weekends" - i(1), "preferred day" - s("tuesday"), "day preference %" - i(25), "mean time of visit (minutes after midnight)" - i(40), "standard deviation from mean" - i(217), "different locations" - i(2), "preferred station" - s("shell"), "preferred station %" - i(68), "% pay cashier (instead of at pump)" - i(9), "payment method" - s("credit"), "preferred pump" - s("07LG"), "preferred pump %" - i(34)])).
car(96, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("3301VHI"), "year" - i(2005), "month" - i(1), "day" - i(17), "hour" - i(14), "minute" - i(50), "station" - s("mobil"), "fill-ups" - i(4), "record history (days)" - i(141), "weekdays" - i(3), "weekends" - i(1), "preferred day" - s("wednesday"), "day preference %" - i(25), "mean time of visit (minutes after midnight)" - i(199), "standard deviation from mean" - i(300), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(50), "% pay cashier (instead of at pump)" - i(25), "payment method" - s("credit"), "preferred pump" - s("17LG"), "preferred pump %" - i(25)])).
car(97, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("6176YHI"), "year" - i(2005), "month" - i(2), "day" - i(23), "hour" - i(14), "minute" - i(57), "station" - s("mobil"), "fill-ups" - i(32), "record history (days)" - i(161), "weekdays" - i(23), "weekends" - i(9), "preferred day" - s("thursday"), "day preference %" - i(31), "mean time of visit (minutes after midnight)" - i(46), "standard deviation from mean" - i(248), "different locations" - i(3), "preferred station" - s("mobil"), "preferred station %" - i(87), "% pay cashier (instead of at pump)" - i(10), "payment method" - s("credit"), "preferred pump" - s("47HG"), "preferred pump %" - i(21)])).
car(98, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("2286YHI"), "year" - i(2005), "month" - i(3), "day" - i(4), "hour" - i(9), "minute" - i(30), "station" - s("shell"), "fill-ups" - i(65), "record history (days)" - i(148), "weekdays" - i(54), "weekends" - i(11), "preferred day" - s("wednesday"), "day preference %" - i(21), "mean time of visit (minutes after midnight)" - i(9), "standard deviation from mean" - i(76), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(63), "% pay cashier (instead of at pump)" - i(4), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(21)])).
car(99, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("1442AHI"), "year" - i(2004), "month" - i(9), "day" - i(29), "hour" - i(11), "minute" - i(7), "station" - s("mobil"), "fill-ups" - i(3), "record history (days)" - i(30), "weekdays" - i(3), "weekends" - i(0), "preferred day" - s("wednesday"), "day preference %" - i(66), "mean time of visit (minutes after midnight)" - i(354), "standard deviation from mean" - i(409), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(33), "payment method" - s("credit"), "preferred pump" - s("27HG"), "preferred pump %" - i(66)])).
car(100, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("0113BHI"), "year" - i(2005), "month" - i(3), "day" - i(3), "hour" - i(17), "minute" - i(44), "station" - s("mobil"), "fill-ups" - i(43), "record history (days)" - i(149), "weekdays" - i(30), "weekends" - i(13), "preferred day" - s("saturday"), "day preference %" - i(20), "mean time of visit (minutes after midnight)" - i(24), "standard deviation from mean" - i(158), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(97), "% pay cashier (instead of at pump)" - i(4), "payment method" - s("credit"), "preferred pump" - s("47HG"), "preferred pump %" - i(23)])).
car(101, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("5913BHI"), "year" - i(2005), "month" - i(3), "day" - i(1), "hour" - i(14), "minute" - i(12), "station" - s("mobil"), "fill-ups" - i(26), "record history (days)" - i(146), "weekdays" - i(22), "weekends" - i(4), "preferred day" - s("wednesday"), "day preference %" - i(26), "mean time of visit (minutes after midnight)" - i(45), "standard deviation from mean" - i(222), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(80), "% pay cashier (instead of at pump)" - i(7), "payment method" - s("credit"), "preferred pump" - s("37HG"), "preferred pump %" - i(23)])).
car(102, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("4323BHI"), "year" - i(2005), "month" - i(2), "day" - i(14), "hour" - i(16), "minute" - i(3), "station" - s("mobil"), "fill-ups" - i(29), "record history (days)" - i(145), "weekdays" - i(22), "weekends" - i(7), "preferred day" - s("thursday"), "day preference %" - i(24), "mean time of visit (minutes after midnight)" - i(32), "standard deviation from mean" - i(167), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(10), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(31)])).
car(103, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("8549CHI"), "year" - i(2004), "month" - i(10), "day" - i(24), "hour" - i(11), "minute" - i(3), "station" - s("mobil"), "fill-ups" - i(3), "record history (days)" - i(1), "weekdays" - i(2), "weekends" - i(1), "preferred day" - s("monday"), "day preference %" - i(66), "mean time of visit (minutes after midnight)" - i(486), "standard deviation from mean" - i(344), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(50), "payment method" - s("credit"), "preferred pump" - s("37HG"), "preferred pump %" - i(66)])).
car(104, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("6044CHI"), "year" - i(2005), "month" - i(2), "day" - i(12), "hour" - i(10), "minute" - i(36), "station" - s("shell"), "fill-ups" - i(20), "record history (days)" - i(144), "weekdays" - i(13), "weekends" - i(7), "preferred day" - s("monday"), "day preference %" - i(30), "mean time of visit (minutes after midnight)" - i(54), "standard deviation from mean" - i(231), "different locations" - i(2), "preferred station" - s("shell"), "preferred station %" - i(60), "% pay cashier (instead of at pump)" - i(10), "payment method" - s("credit"), "preferred pump" - s("17LG"), "preferred pump %" - i(20)])).
car(105, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("3279EHI"), "year" - i(2004), "month" - i(12), "day" - i(15), "hour" - i(17), "minute" - i(10), "station" - s("mobil"), "fill-ups" - i(8), "record history (days)" - i(81), "weekdays" - i(4), "weekends" - i(4), "preferred day" - s("saturday"), "day preference %" - i(37), "mean time of visit (minutes after midnight)" - i(99), "standard deviation from mean" - i(247), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(87), "% pay cashier (instead of at pump)" - i(25), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(50)])).
car(106, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("9261EHI"), "year" - i(2005), "month" - i(1), "day" - i(1), "hour" - i(0), "minute" - i(23), "station" - s("mobil"), "fill-ups" - i(10), "record history (days)" - i(131), "weekdays" - i(3), "weekends" - i(7), "preferred day" - s("sunday"), "day preference %" - i(40), "mean time of visit (minutes after midnight)" - i(114), "standard deviation from mean" - i(305), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(90), "% pay cashier (instead of at pump)" - i(22), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(40)])).
car(107, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("7986EHI"), "year" - i(2004), "month" - i(11), "day" - i(12), "hour" - i(17), "minute" - i(11), "station" - s("mobil"), "fill-ups" - i(2), "record history (days)" - i(63), "weekdays" - i(2), "weekends" - i(0), "preferred day" - s("tuesday"), "day preference %" - i(50), "mean time of visit (minutes after midnight)" - i(461), "standard deviation from mean" - i(327), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(50), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(50)])).
car(108, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("4119HHI"), "year" - i(2004), "month" - i(11), "day" - i(7), "hour" - i(19), "minute" - i(54), "station" - s("mobil"), "fill-ups" - i(18), "record history (days)" - i(149), "weekdays" - i(6), "weekends" - i(12), "preferred day" - s("sunday"), "day preference %" - i(61), "mean time of visit (minutes after midnight)" - i(74), "standard deviation from mean" - i(289), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(94), "% pay cashier (instead of at pump)" - i(11), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(72)])).
car(109, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("9126HHI"), "year" - i(2005), "month" - i(3), "day" - i(2), "hour" - i(16), "minute" - i(12), "station" - s("mobil"), "fill-ups" - i(28), "record history (days)" - i(166), "weekdays" - i(15), "weekends" - i(13), "preferred day" - s("saturday"), "day preference %" - i(32), "mean time of visit (minutes after midnight)" - i(46), "standard deviation from mean" - i(231), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(89), "% pay cashier (instead of at pump)" - i(11), "payment method" - s("credit"), "preferred pump" - s("27HG"), "preferred pump %" - i(25)])).
car(110, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("6646HHI"), "year" - i(2004), "month" - i(11), "day" - i(20), "hour" - i(1), "minute" - i(43), "station" - s("mobil"), "fill-ups" - i(6), "record history (days)" - i(148), "weekdays" - i(4), "weekends" - i(2), "preferred day" - s("tuesday"), "day preference %" - i(33), "mean time of visit (minutes after midnight)" - i(4), "standard deviation from mean" - i(9), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(66), "% pay cashier (instead of at pump)" - i(16), "payment method" - s("credit"), "preferred pump" - s("17LG"), "preferred pump %" - i(16)])).
car(111, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("1156HHI"), "year" - i(2005), "month" - i(3), "day" - i(1), "hour" - i(11), "minute" - i(59), "station" - s("mobil"), "fill-ups" - i(24), "record history (days)" - i(146), "weekdays" - i(14), "weekends" - i(10), "preferred day" - s("tuesday"), "day preference %" - i(25), "mean time of visit (minutes after midnight)" - i(58), "standard deviation from mean" - i(267), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(8), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(37)])).
car(112, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("3856HHI"), "year" - i(2005), "month" - i(3), "day" - i(3), "hour" - i(18), "minute" - i(12), "station" - s("mobil"), "fill-ups" - i(24), "record history (days)" - i(170), "weekdays" - i(15), "weekends" - i(9), "preferred day" - s("sunday"), "day preference %" - i(25), "mean time of visit (minutes after midnight)" - i(58), "standard deviation from mean" - i(270), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(91), "% pay cashier (instead of at pump)" - i(13), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(45)])).
car(113, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("5266HHI"), "year" - i(2005), "month" - i(1), "day" - i(31), "hour" - i(8), "minute" - i(17), "station" - s("shell"), "fill-ups" - i(23), "record history (days)" - i(147), "weekdays" - i(16), "weekends" - i(7), "preferred day" - s("tuesday"), "day preference %" - i(17), "mean time of visit (minutes after midnight)" - i(51), "standard deviation from mean" - i(236), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(65), "% pay cashier (instead of at pump)" - i(8), "payment method" - s("credit"), "preferred pump" - s("97LG"), "preferred pump %" - i(26)])).
car(114, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("7366HHI"), "year" - i(2005), "month" - i(1), "day" - i(15), "hour" - i(18), "minute" - i(42), "station" - s("shell"), "fill-ups" - i(103), "record history (days)" - i(148), "weekdays" - i(85), "weekends" - i(18), "preferred day" - s("friday"), "day preference %" - i(18), "mean time of visit (minutes after midnight)" - i(8), "standard deviation from mean" - i(89), "different locations" - i(2), "preferred station" - s("shell"), "preferred station %" - i(86), "% pay cashier (instead of at pump)" - i(2), "payment method" - s("credit"), "preferred pump" - s("97LG"), "preferred pump %" - i(32)])).
car(115, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("8666HHI"), "year" - i(2005), "month" - i(2), "day" - i(17), "hour" - i(10), "minute" - i(41), "station" - s("mobil"), "fill-ups" - i(29), "record history (days)" - i(147), "weekdays" - i(19), "weekends" - i(10), "preferred day" - s("thursday"), "day preference %" - i(17), "mean time of visit (minutes after midnight)" - i(37), "standard deviation from mean" - i(184), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(7), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(27)])).
car(116, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("5186HHI"), "year" - i(2005), "month" - i(2), "day" - i(24), "hour" - i(10), "minute" - i(28), "station" - s("mobil"), "fill-ups" - i(71), "record history (days)" - i(161), "weekdays" - i(56), "weekends" - i(15), "preferred day" - s("tuesday"), "day preference %" - i(22), "mean time of visit (minutes after midnight)" - i(13), "standard deviation from mean" - i(107), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(56), "% pay cashier (instead of at pump)" - i(5), "payment method" - s("credit"), "preferred pump" - s("27LG"), "preferred pump %" - i(15)])).
car(117, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("6286HHI"), "year" - i(2005), "month" - i(3), "day" - i(1), "hour" - i(21), "minute" - i(52), "station" - s("shell"), "fill-ups" - i(81), "record history (days)" - i(146), "weekdays" - i(52), "weekends" - i(29), "preferred day" - s("sunday"), "day preference %" - i(22), "mean time of visit (minutes after midnight)" - i(17), "standard deviation from mean" - i(152), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(85), "% pay cashier (instead of at pump)" - i(5), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(22)])).
car(118, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("7017HHI"), "year" - i(2005), "month" - i(1), "day" - i(17), "hour" - i(18), "minute" - i(26), "station" - s("mobil"), "fill-ups" - i(40), "record history (days)" - i(146), "weekdays" - i(32), "weekends" - i(8), "preferred day" - s("thursday"), "day preference %" - i(25), "mean time of visit (minutes after midnight)" - i(31), "standard deviation from mean" - i(191), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(92), "% pay cashier (instead of at pump)" - i(5), "payment method" - s("credit"), "preferred pump" - s("47HG"), "preferred pump %" - i(22)])).
car(119, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("0293MHI"), "year" - i(2005), "month" - i(1), "day" - i(22), "hour" - i(22), "minute" - i(27), "station" - s("shell"), "fill-ups" - i(8), "record history (days)" - i(141), "weekdays" - i(4), "weekends" - i(4), "preferred day" - s("sunday"), "day preference %" - i(37), "mean time of visit (minutes after midnight)" - i(172), "standard deviation from mean" - i(428), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(75), "% pay cashier (instead of at pump)" - i(12), "payment method" - s("credit"), "preferred pump" - s("97LG"), "preferred pump %" - i(25)])).
car(120, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("6437MHI"), "year" - i(2005), "month" - i(2), "day" - i(26), "hour" - i(20), "minute" - i(37), "station" - s("shell"), "fill-ups" - i(8), "record history (days)" - i(161), "weekdays" - i(3), "weekends" - i(5), "preferred day" - s("saturday"), "day preference %" - i(37), "mean time of visit (minutes after midnight)" - i(118), "standard deviation from mean" - i(294), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(75), "% pay cashier (instead of at pump)" - i(12), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(37)])).
car(121, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("7593NHI"), "year" - i(2005), "month" - i(1), "day" - i(8), "hour" - i(13), "minute" - i(25), "station" - s("shell"), "fill-ups" - i(9), "record history (days)" - i(146), "weekdays" - i(5), "weekends" - i(4), "preferred day" - s("friday"), "day preference %" - i(33), "mean time of visit (minutes after midnight)" - i(90), "standard deviation from mean" - i(241), "different locations" - i(2), "preferred station" - s("shell"), "preferred station %" - i(88), "% pay cashier (instead of at pump)" - i(22), "payment method" - s("credit"), "preferred pump" - s("17LG"), "preferred pump %" - i(33)])).
car(122, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("6760OHI"), "year" - i(2005), "month" - i(3), "day" - i(3), "hour" - i(14), "minute" - i(35), "station" - s("mobil"), "fill-ups" - i(85), "record history (days)" - i(148), "weekdays" - i(60), "weekends" - i(25), "preferred day" - s("tuesday"), "day preference %" - i(16), "mean time of visit (minutes after midnight)" - i(1), "standard deviation from mean" - i(9), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(89), "% pay cashier (instead of at pump)" - i(3), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(29)])).
car(123, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("5376OHI"), "year" - i(2005), "month" - i(2), "day" - i(28), "hour" - i(20), "minute" - i(28), "station" - s("mobil"), "fill-ups" - i(23), "record history (days)" - i(158), "weekdays" - i(22), "weekends" - i(1), "preferred day" - s("thursday"), "day preference %" - i(39), "mean time of visit (minutes after midnight)" - i(46), "standard deviation from mean" - i(215), "different locations" - i(2), "preferred station" - s("shell"), "preferred station %" - i(82), "% pay cashier (instead of at pump)" - i(8), "payment method" - s("credit"), "preferred pump" - s("27LG"), "preferred pump %" - i(30)])).
car(124, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("6614PII"), "year" - i(2004), "month" - i(5), "day" - i(14), "hour" - i(15), "minute" - i(1), "station" - s("mobil"), "fill-ups" - i(7), "record history (days)" - i(30), "weekdays" - i(6), "weekends" - i(1), "preferred day" - s("wednesday"), "day preference %" - i(28), "mean time of visit (minutes after midnight)" - i(168), "standard deviation from mean" - i(382), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(71), "% pay cashier (instead of at pump)" - i(14), "payment method" - s("credit"), "preferred pump" - s("27HG"), "preferred pump %" - i(42)])).
car(125, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("8661QII"), "year" - i(2005), "month" - i(3), "day" - i(1), "hour" - i(22), "minute" - i(13), "station" - s("mobil"), "fill-ups" - i(17), "record history (days)" - i(125), "weekdays" - i(10), "weekends" - i(7), "preferred day" - s("friday"), "day preference %" - i(35), "mean time of visit (minutes after midnight)" - i(6), "standard deviation from mean" - i(26), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(94), "% pay cashier (instead of at pump)" - i(12), "payment method" - s("credit"), "preferred pump" - s("37HG"), "preferred pump %" - i(29)])).
car(126, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("3901RII"), "year" - i(2005), "month" - i(2), "day" - i(8), "hour" - i(17), "minute" - i(11), "station" - s("mobil"), "fill-ups" - i(11), "record history (days)" - i(140), "weekdays" - i(9), "weekends" - i(2), "preferred day" - s("friday"), "day preference %" - i(36), "mean time of visit (minutes after midnight)" - i(117), "standard deviation from mean" - i(335), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(20), "payment method" - s("credit"), "preferred pump" - s("37HG"), "preferred pump %" - i(45)])).
car(127, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("9727RII"), "year" - i(2005), "month" - i(2), "day" - i(26), "hour" - i(18), "minute" - i(22), "station" - s("mobil"), "fill-ups" - i(25), "record history (days)" - i(160), "weekdays" - i(13), "weekends" - i(12), "preferred day" - s("sunday"), "day preference %" - i(24), "mean time of visit (minutes after midnight)" - i(26), "standard deviation from mean" - i(125), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(92), "% pay cashier (instead of at pump)" - i(12), "payment method" - s("credit"), "preferred pump" - s("27HG"), "preferred pump %" - i(36)])).
car(128, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("7879TII"), "year" - i(2004), "month" - i(7), "day" - i(10), "hour" - i(0), "minute" - i(23), "station" - s("mobil"), "fill-ups" - i(14), "record history (days)" - i(123), "weekdays" - i(11), "weekends" - i(3), "preferred day" - s("friday"), "day preference %" - i(28), "mean time of visit (minutes after midnight)" - i(2), "standard deviation from mean" - i(10), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(71), "% pay cashier (instead of at pump)" - i(14), "payment method" - s("credit"), "preferred pump" - s("27HG"), "preferred pump %" - i(28)])).
car(129, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("4780UII"), "year" - i(2005), "month" - i(2), "day" - i(22), "hour" - i(20), "minute" - i(8), "station" - s("mobil"), "fill-ups" - i(13), "record history (days)" - i(153), "weekdays" - i(11), "weekends" - i(2), "preferred day" - s("tuesday"), "day preference %" - i(38), "mean time of visit (minutes after midnight)" - i(53), "standard deviation from mean" - i(179), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(7), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(38)])).
car(130, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("1563UII"), "year" - i(2004), "month" - i(12), "day" - i(27), "hour" - i(19), "minute" - i(26), "station" - s("mobil"), "fill-ups" - i(7), "record history (days)" - i(97), "weekdays" - i(5), "weekends" - i(2), "preferred day" - s("wednesday"), "day preference %" - i(28), "mean time of visit (minutes after midnight)" - i(128), "standard deviation from mean" - i(291), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(85), "% pay cashier (instead of at pump)" - i(14), "payment method" - s("credit"), "preferred pump" - s("47HG"), "preferred pump %" - i(28)])).
car(131, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("4091VII"), "year" - i(2004), "month" - i(12), "day" - i(13), "hour" - i(12), "minute" - i(54), "station" - s("mobil"), "fill-ups" - i(12), "record history (days)" - i(131), "weekdays" - i(6), "weekends" - i(6), "preferred day" - s("sunday"), "day preference %" - i(33), "mean time of visit (minutes after midnight)" - i(97), "standard deviation from mean" - i(278), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(66), "% pay cashier (instead of at pump)" - i(10), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(25)])).
car(132, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("4076VII"), "year" - i(2004), "month" - i(12), "day" - i(16), "hour" - i(15), "minute" - i(38), "station" - s("mobil"), "fill-ups" - i(24), "record history (days)" - i(142), "weekdays" - i(15), "weekends" - i(9), "preferred day" - s("friday"), "day preference %" - i(25), "mean time of visit (minutes after midnight)" - i(41), "standard deviation from mean" - i(189), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(8), "payment method" - s("credit"), "preferred pump" - s("27HG"), "preferred pump %" - i(29)])).
car(133, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("8197VII"), "year" - i(2004), "month" - i(5), "day" - i(29), "hour" - i(19), "minute" - i(57), "station" - s("mobil"), "fill-ups" - i(3), "record history (days)" - i(84), "weekdays" - i(1), "weekends" - i(2), "preferred day" - s("saturday"), "day preference %" - i(66), "mean time of visit (minutes after midnight)" - i(386), "standard deviation from mean" - i(446), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(66), "payment method" - s("credit"), "preferred pump" - s("47HG"), "preferred pump %" - i(33)])).
car(134, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("9293WII"), "year" - i(2004), "month" - i(12), "day" - i(21), "hour" - i(4), "minute" - i(40), "station" - s("mobil"), "fill-ups" - i(3), "record history (days)" - i(92), "weekdays" - i(1), "weekends" - i(2), "preferred day" - s("wednesday"), "day preference %" - i(33), "mean time of visit (minutes after midnight)" - i(57), "standard deviation from mean" - i(66), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(33), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(66)])).
car(135, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("7TNI968"), "year" - i(2005), "month" - i(3), "day" - i(3), "hour" - i(20), "minute" - i(33), "station" - s("shell"), "fill-ups" - i(81), "record history (days)" - i(160), "weekdays" - i(76), "weekends" - i(5), "preferred day" - s("tuesday"), "day preference %" - i(20), "mean time of visit (minutes after midnight)" - i(15), "standard deviation from mean" - i(136), "different locations" - i(2), "preferred station" - s("shell"), "preferred station %" - i(61), "% pay cashier (instead of at pump)" - i(5), "payment method" - s("credit"), "preferred pump" - s("27LG"), "preferred pump %" - i(24)])).
car(136, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("2CNI568"), "year" - i(2005), "month" - i(2), "day" - i(26), "hour" - i(15), "minute" - i(2), "station" - s("mobil"), "fill-ups" - i(18), "record history (days)" - i(164), "weekdays" - i(11), "weekends" - i(7), "preferred day" - s("saturday"), "day preference %" - i(27), "mean time of visit (minutes after midnight)" - i(77), "standard deviation from mean" - i(311), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(94), "% pay cashier (instead of at pump)" - i(5), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(22)])).
car(137, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("0DNI568"), "year" - i(2005), "month" - i(2), "day" - i(25), "hour" - i(23), "minute" - i(15), "station" - s("mobil"), "fill-ups" - i(46), "record history (days)" - i(158), "weekdays" - i(35), "weekends" - i(11), "preferred day" - s("friday"), "day preference %" - i(23), "mean time of visit (minutes after midnight)" - i(1), "standard deviation from mean" - i(8), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(82), "% pay cashier (instead of at pump)" - i(6), "payment method" - s("credit"), "preferred pump" - s("37HG"), "preferred pump %" - i(23)])).
car(138, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("4CNI491"), "year" - i(2005), "month" - i(2), "day" - i(14), "hour" - i(10), "minute" - i(18), "station" - s("mobil"), "fill-ups" - i(19), "record history (days)" - i(145), "weekdays" - i(14), "weekends" - i(5), "preferred day" - s("friday"), "day preference %" - i(26), "mean time of visit (minutes after midnight)" - i(75), "standard deviation from mean" - i(303), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(73), "% pay cashier (instead of at pump)" - i(5), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(36)])).
car(139, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("0TNI101"), "year" - i(2004), "month" - i(11), "day" - i(19), "hour" - i(21), "minute" - i(49), "station" - s("mobil"), "fill-ups" - i(3), "record history (days)" - i(137), "weekdays" - i(2), "weekends" - i(1), "preferred day" - s("friday"), "day preference %" - i(66), "mean time of visit (minutes after midnight)" - i(400), "standard deviation from mean" - i(462), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(33), "payment method" - s("credit"), "preferred pump" - s("47HG"), "preferred pump %" - i(33)])).
car(140, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("5DNI625"), "year" - i(2004), "month" - i(8), "day" - i(2), "hour" - i(20), "minute" - i(36), "station" - s("shell"), "fill-ups" - i(4), "record history (days)" - i(129), "weekdays" - i(4), "weekends" - i(0), "preferred day" - s("friday"), "day preference %" - i(50), "mean time of visit (minutes after midnight)" - i(336), "standard deviation from mean" - i(505), "different locations" - i(2), "preferred station" - s("shell"), "preferred station %" - i(75), "% pay cashier (instead of at pump)" - i(25), "payment method" - s("credit"), "preferred pump" - s("07LG"), "preferred pump %" - i(50)])).
car(141, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("0944CPO"), "year" - i(2005), "month" - i(3), "day" - i(2), "hour" - i(16), "minute" - i(28), "station" - s("shell"), "fill-ups" - i(34), "record history (days)" - i(168), "weekdays" - i(23), "weekends" - i(11), "preferred day" - s("friday"), "day preference %" - i(35), "mean time of visit (minutes after midnight)" - i(24), "standard deviation from mean" - i(134), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(61), "% pay cashier (instead of at pump)" - i(6), "payment method" - s("credit"), "preferred pump" - s("97LG"), "preferred pump %" - i(14)])).
car(142, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("0ENI032"), "year" - i(2005), "month" - i(2), "day" - i(12), "hour" - i(15), "minute" - i(32), "station" - s("mobil"), "fill-ups" - i(16), "record history (days)" - i(143), "weekdays" - i(11), "weekends" - i(5), "preferred day" - s("thursday"), "day preference %" - i(25), "mean time of visit (minutes after midnight)" - i(57), "standard deviation from mean" - i(209), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(13), "payment method" - s("credit"), "preferred pump" - s("37HG"), "preferred pump %" - i(62)])).
car(143, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("7SNI587"), "year" - i(2005), "month" - i(2), "day" - i(5), "hour" - i(10), "minute" - i(11), "station" - s("mobil"), "fill-ups" - i(29), "record history (days)" - i(147), "weekdays" - i(23), "weekends" - i(6), "preferred day" - s("tuesday"), "day preference %" - i(27), "mean time of visit (minutes after midnight)" - i(44), "standard deviation from mean" - i(230), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(68), "% pay cashier (instead of at pump)" - i(10), "payment method" - s("credit"), "preferred pump" - s("37HG"), "preferred pump %" - i(24)])).
car(144, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("2665VII"), "year" - i(2004), "month" - i(7), "day" - i(19), "hour" - i(23), "minute" - i(56), "station" - s("mobil"), "fill-ups" - i(20), "record history (days)" - i(75), "weekdays" - i(16), "weekends" - i(4), "preferred day" - s("wednesday"), "day preference %" - i(20), "mean time of visit (minutes after midnight)" - i(41), "standard deviation from mean" - i(176), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(95), "% pay cashier (instead of at pump)" - i(10), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(40)])).
car(145, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("9DNI553"), "year" - i(2005), "month" - i(2), "day" - i(12), "hour" - i(13), "minute" - i(33), "station" - s("mobil"), "fill-ups" - i(78), "record history (days)" - i(147), "weekdays" - i(58), "weekends" - i(20), "preferred day" - s("wednesday"), "day preference %" - i(16), "mean time of visit (minutes after midnight)" - i(13), "standard deviation from mean" - i(113), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(98), "% pay cashier (instead of at pump)" - i(5), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(98)])).
car(146, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("81436BH"), "year" - i(2004), "month" - i(12), "day" - i(31), "hour" - i(10), "minute" - i(8), "station" - s("mobil"), "fill-ups" - i(4), "record history (days)" - i(105), "weekdays" - i(3), "weekends" - i(1), "preferred day" - s("tuesday"), "day preference %" - i(25), "mean time of visit (minutes after midnight)" - i(226), "standard deviation from mean" - i(339), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(25), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(75)])).
car(147, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("6DNI126"), "year" - i(2005), "month" - i(2), "day" - i(21), "hour" - i(16), "minute" - i(52), "station" - s("mobil"), "fill-ups" - i(27), "record history (days)" - i(159), "weekdays" - i(23), "weekends" - i(4), "preferred day" - s("tuesday"), "day preference %" - i(25), "mean time of visit (minutes after midnight)" - i(50), "standard deviation from mean" - i(242), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(92), "% pay cashier (instead of at pump)" - i(12), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(37)])).
car(148, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("5DNI914"), "year" - i(2005), "month" - i(2), "day" - i(25), "hour" - i(19), "minute" - i(31), "station" - s("7-Eleven"), "fill-ups" - i(26), "record history (days)" - i(161), "weekdays" - i(17), "weekends" - i(9), "preferred day" - s("monday"), "day preference %" - i(30), "mean time of visit (minutes after midnight)" - i(28), "standard deviation from mean" - i(141), "different locations" - i(3), "preferred station" - s("mobil"), "preferred station %" - i(84), "% pay cashier (instead of at pump)" - i(7), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(15)])).
car(149, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("86317DH"), "year" - i(2005), "month" - i(1), "day" - i(6), "hour" - i(14), "minute" - i(35), "station" - s("mobil"), "fill-ups" - i(33), "record history (days)" - i(142), "weekdays" - i(25), "weekends" - i(8), "preferred day" - s("wednesday"), "day preference %" - i(18), "mean time of visit (minutes after midnight)" - i(24), "standard deviation from mean" - i(133), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(6), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(27)])).
car(150, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("4294LJM"), "year" - i(2005), "month" - i(3), "day" - i(3), "hour" - i(11), "minute" - i(13), "station" - s("mobil"), "fill-ups" - i(108), "record history (days)" - i(167), "weekdays" - i(91), "weekends" - i(17), "preferred day" - s("wednesday"), "day preference %" - i(19), "mean time of visit (minutes after midnight)" - i(6), "standard deviation from mean" - i(67), "different locations" - i(2), "preferred station" - s("shell"), "preferred station %" - i(75), "% pay cashier (instead of at pump)" - i(4), "payment method" - s("credit"), "preferred pump" - s("07LG"), "preferred pump %" - i(23)])).
car(151, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("2XNI386"), "year" - i(2005), "month" - i(3), "day" - i(2), "hour" - i(10), "minute" - i(25), "station" - s("shell"), "fill-ups" - i(33), "record history (days)" - i(162), "weekdays" - i(27), "weekends" - i(6), "preferred day" - s("monday"), "day preference %" - i(36), "mean time of visit (minutes after midnight)" - i(24), "standard deviation from mean" - i(137), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(93), "% pay cashier (instead of at pump)" - i(12), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(72)])).
car(152, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("5VNI741"), "year" - i(2005), "month" - i(1), "day" - i(31), "hour" - i(22), "minute" - i(36), "station" - s("mobil"), "fill-ups" - i(11), "record history (days)" - i(145), "weekdays" - i(6), "weekends" - i(5), "preferred day" - s("sunday"), "day preference %" - i(27), "mean time of visit (minutes after midnight)" - i(54), "standard deviation from mean" - i(164), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(9), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(27)])).
car(153, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("3VNI941"), "year" - i(2005), "month" - i(1), "day" - i(19), "hour" - i(9), "minute" - i(58), "station" - s("mobil"), "fill-ups" - i(79), "record history (days)" - i(147), "weekdays" - i(60), "weekends" - i(19), "preferred day" - s("wednesday"), "day preference %" - i(29), "mean time of visit (minutes after midnight)" - i(9), "standard deviation from mean" - i(80), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(94), "% pay cashier (instead of at pump)" - i(4), "payment method" - s("credit"), "preferred pump" - s("27HG"), "preferred pump %" - i(20)])).
car(154, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("6VNI241"), "year" - i(2005), "month" - i(3), "day" - i(1), "hour" - i(10), "minute" - i(5), "station" - s("mobil"), "fill-ups" - i(17), "record history (days)" - i(168), "weekdays" - i(7), "weekends" - i(10), "preferred day" - s("sunday"), "day preference %" - i(41), "mean time of visit (minutes after midnight)" - i(95), "standard deviation from mean" - i(347), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(94), "% pay cashier (instead of at pump)" - i(13), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(35)])).
car(155, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("1565WII"), "year" - i(2004), "month" - i(12), "day" - i(1), "hour" - i(10), "minute" - i(18), "station" - s("mobil"), "fill-ups" - i(3), "record history (days)" - i(125), "weekdays" - i(3), "weekends" - i(0), "preferred day" - s("tuesday"), "day preference %" - i(33), "mean time of visit (minutes after midnight)" - i(301), "standard deviation from mean" - i(348), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(33), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(66)])).
car(156, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("2203YII"), "year" - i(2005), "month" - i(2), "day" - i(8), "hour" - i(15), "minute" - i(52), "station" - s("mobil"), "fill-ups" - i(11), "record history (days)" - i(138), "weekdays" - i(8), "weekends" - i(3), "preferred day" - s("thursday"), "day preference %" - i(27), "mean time of visit (minutes after midnight)" - i(60), "standard deviation from mean" - i(173), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(90), "% pay cashier (instead of at pump)" - i(10), "payment method" - s("credit"), "preferred pump" - s("37HG"), "preferred pump %" - i(36)])).
car(157, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("8623YII"), "year" - i(2005), "month" - i(3), "day" - i(2), "hour" - i(16), "minute" - i(27), "station" - s("mobil"), "fill-ups" - i(48), "record history (days)" - i(166), "weekdays" - i(37), "weekends" - i(11), "preferred day" - s("friday"), "day preference %" - i(20), "mean time of visit (minutes after midnight)" - i(19), "standard deviation from mean" - i(132), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(97), "% pay cashier (instead of at pump)" - i(6), "payment method" - s("credit"), "preferred pump" - s("47HG"), "preferred pump %" - i(27)])).
car(158, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("7506YII"), "year" - i(2005), "month" - i(2), "day" - i(11), "hour" - i(21), "minute" - i(45), "station" - s("shell"), "fill-ups" - i(7), "record history (days)" - i(127), "weekdays" - i(4), "weekends" - i(3), "preferred day" - s("friday"), "day preference %" - i(57), "mean time of visit (minutes after midnight)" - i(11), "standard deviation from mean" - i(24), "different locations" - i(2), "preferred station" - s("shell"), "preferred station %" - i(71), "% pay cashier (instead of at pump)" - i(16), "payment method" - s("credit"), "preferred pump" - s("07LG"), "preferred pump %" - i(28)])).
car(159, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("9416YII"), "year" - i(2005), "month" - i(1), "day" - i(8), "hour" - i(14), "minute" - i(32), "station" - s("mobil"), "fill-ups" - i(2), "record history (days)" - i(42), "weekdays" - i(0), "weekends" - i(2), "preferred day" - s("saturday"), "day preference %" - i(100), "mean time of visit (minutes after midnight)" - i(452), "standard deviation from mean" - i(320), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(50), "payment method" - s("credit"), "preferred pump" - s("47HG"), "preferred pump %" - i(50)])).
car(160, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("6791AII"), "year" - i(2005), "month" - i(2), "day" - i(26), "hour" - i(17), "minute" - i(7), "station" - s("shell"), "fill-ups" - i(36), "record history (days)" - i(132), "weekdays" - i(26), "weekends" - i(10), "preferred day" - s("monday"), "day preference %" - i(22), "mean time of visit (minutes after midnight)" - i(3), "standard deviation from mean" - i(21), "different locations" - i(3), "preferred station" - s("mobil"), "preferred station %" - i(55), "% pay cashier (instead of at pump)" - i(5), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(19)])).
car(161, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("0195AII"), "year" - i(2005), "month" - i(1), "day" - i(25), "hour" - i(14), "minute" - i(21), "station" - s("mobil"), "fill-ups" - i(11), "record history (days)" - i(130), "weekdays" - i(10), "weekends" - i(1), "preferred day" - s("monday"), "day preference %" - i(36), "mean time of visit (minutes after midnight)" - i(117), "standard deviation from mean" - i(355), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(54), "% pay cashier (instead of at pump)" - i(18), "payment method" - s("credit"), "preferred pump" - s("27LG"), "preferred pump %" - i(27)])).
car(162, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("9805AII"), "year" - i(2005), "month" - i(2), "day" - i(27), "hour" - i(0), "minute" - i(52), "station" - s("mobil"), "fill-ups" - i(12), "record history (days)" - i(154), "weekdays" - i(5), "weekends" - i(7), "preferred day" - s("sunday"), "day preference %" - i(50), "mean time of visit (minutes after midnight)" - i(6), "standard deviation from mean" - i(21), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(83), "% pay cashier (instead of at pump)" - i(16), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(25)])).
car(163, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("4946III"), "year" - i(2005), "month" - i(2), "day" - i(19), "hour" - i(20), "minute" - i(54), "station" - s("mobil"), "fill-ups" - i(2), "record history (days)" - i(6), "weekdays" - i(0), "weekends" - i(2), "preferred day" - s("sunday"), "day preference %" - i(50), "mean time of visit (minutes after midnight)" - i(380), "standard deviation from mean" - i(269), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(50), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(100)])).
car(164, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("0ENI357"), "year" - i(2005), "month" - i(1), "day" - i(19), "hour" - i(21), "minute" - i(27), "station" - s("mobil"), "fill-ups" - i(20), "record history (days)" - i(140), "weekdays" - i(12), "weekends" - i(8), "preferred day" - s("sunday"), "day preference %" - i(25), "mean time of visit (minutes after midnight)" - i(52), "standard deviation from mean" - i(208), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(75), "% pay cashier (instead of at pump)" - i(11), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(35)])).
car(165, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("7TNI900"), "year" - i(2005), "month" - i(1), "day" - i(26), "hour" - i(10), "minute" - i(31), "station" - s("mobil"), "fill-ups" - i(25), "record history (days)" - i(148), "weekdays" - i(21), "weekends" - i(4), "preferred day" - s("friday"), "day preference %" - i(40), "mean time of visit (minutes after midnight)" - i(27), "standard deviation from mean" - i(130), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(12), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(64)])).
car(166, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("0ZNI000"), "year" - i(2005), "month" - i(2), "day" - i(12), "hour" - i(4), "minute" - i(5), "station" - s("mobil"), "fill-ups" - i(69), "record history (days)" - i(148), "weekdays" - i(54), "weekends" - i(15), "preferred day" - s("thursday"), "day preference %" - i(21), "mean time of visit (minutes after midnight)" - i(9), "standard deviation from mean" - i(74), "different locations" - i(2), "preferred station" - s("shell"), "preferred station %" - i(68), "% pay cashier (instead of at pump)" - i(4), "payment method" - s("credit"), "preferred pump" - s("17LG"), "preferred pump %" - i(30)])).
car(167, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("2TNI100"), "year" - i(2005), "month" - i(2), "day" - i(8), "hour" - i(12), "minute" - i(23), "station" - s("mobil"), "fill-ups" - i(13), "record history (days)" - i(144), "weekdays" - i(10), "weekends" - i(3), "preferred day" - s("monday"), "day preference %" - i(23), "mean time of visit (minutes after midnight)" - i(116), "standard deviation from mean" - i(352), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(18), "payment method" - s("credit"), "preferred pump" - s("27HG"), "preferred pump %" - i(38)])).
car(168, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("5ZNI200"), "year" - i(2005), "month" - i(1), "day" - i(13), "hour" - i(15), "minute" - i(27), "station" - s("mobil"), "fill-ups" - i(55), "record history (days)" - i(146), "weekdays" - i(48), "weekends" - i(7), "preferred day" - s("thursday"), "day preference %" - i(21), "mean time of visit (minutes after midnight)" - i(20), "standard deviation from mean" - i(143), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(6), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(60)])).
car(169, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("0WNI404"), "year" - i(2005), "month" - i(2), "day" - i(26), "hour" - i(19), "minute" - i(25), "station" - s("shell"), "fill-ups" - i(19), "record history (days)" - i(140), "weekdays" - i(8), "weekends" - i(11), "preferred day" - s("saturday"), "day preference %" - i(36), "mean time of visit (minutes after midnight)" - i(72), "standard deviation from mean" - i(298), "different locations" - i(2), "preferred station" - s("shell"), "preferred station %" - i(73), "% pay cashier (instead of at pump)" - i(5), "payment method" - s("credit"), "preferred pump" - s("27LG"), "preferred pump %" - i(26)])).
car(170, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("5ZNI714"), "year" - i(2005), "month" - i(2), "day" - i(22), "hour" - i(11), "minute" - i(49), "station" - s("mobil"), "fill-ups" - i(38), "record history (days)" - i(152), "weekdays" - i(32), "weekends" - i(6), "preferred day" - s("friday"), "day preference %" - i(23), "mean time of visit (minutes after midnight)" - i(22), "standard deviation from mean" - i(130), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(97), "% pay cashier (instead of at pump)" - i(5), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(47)])).
car(171, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("2XNI614"), "year" - i(2005), "month" - i(2), "day" - i(1), "hour" - i(9), "minute" - i(3), "station" - s("shell"), "fill-ups" - i(21), "record history (days)" - i(148), "weekdays" - i(16), "weekends" - i(5), "preferred day" - s("monday"), "day preference %" - i(23), "mean time of visit (minutes after midnight)" - i(3), "standard deviation from mean" - i(14), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(90), "% pay cashier (instead of at pump)" - i(10), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(28)])).
car(172, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("9YNI983"), "year" - i(2004), "month" - i(12), "day" - i(21), "hour" - i(8), "minute" - i(36), "station" - s("shell"), "fill-ups" - i(16), "record history (days)" - i(146), "weekdays" - i(5), "weekends" - i(11), "preferred day" - s("sunday"), "day preference %" - i(56), "mean time of visit (minutes after midnight)" - i(40), "standard deviation from mean" - i(152), "different locations" - i(2), "preferred station" - s("shell"), "preferred station %" - i(87), "% pay cashier (instead of at pump)" - i(6), "payment method" - s("credit"), "preferred pump" - s("97LG"), "preferred pump %" - i(43)])).
car(173, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("6805NJM"), "year" - i(2005), "month" - i(3), "day" - i(1), "hour" - i(13), "minute" - i(25), "station" - s("mobil"), "fill-ups" - i(29), "record history (days)" - i(165), "weekdays" - i(21), "weekends" - i(8), "preferred day" - s("monday"), "day preference %" - i(27), "mean time of visit (minutes after midnight)" - i(3), "standard deviation from mean" - i(18), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(3), "payment method" - s("credit"), "preferred pump" - s("47HG"), "preferred pump %" - i(34)])).
car(174, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("2DNI856"), "year" - i(2005), "month" - i(1), "day" - i(15), "hour" - i(13), "minute" - i(34), "station" - s("mobil"), "fill-ups" - i(15), "record history (days)" - i(91), "weekdays" - i(11), "weekends" - i(4), "preferred day" - s("tuesday"), "day preference %" - i(20), "mean time of visit (minutes after midnight)" - i(1), "standard deviation from mean" - i(7), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(13), "payment method" - s("credit"), "preferred pump" - s("37HG"), "preferred pump %" - i(66)])).
car(175, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("2TNI317"), "year" - i(2005), "month" - i(1), "day" - i(12), "hour" - i(13), "minute" - i(14), "station" - s("mobil"), "fill-ups" - i(39), "record history (days)" - i(145), "weekdays" - i(31), "weekends" - i(8), "preferred day" - s("thursday"), "day preference %" - i(20), "mean time of visit (minutes after midnight)" - i(24), "standard deviation from mean" - i(146), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(58), "% pay cashier (instead of at pump)" - i(7), "payment method" - s("credit"), "preferred pump" - s("97LG"), "preferred pump %" - i(20)])).
car(176, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("2395UII"), "year" - i(2005), "month" - i(1), "day" - i(15), "hour" - i(11), "minute" - i(13), "station" - s("shell"), "fill-ups" - i(2), "record history (days)" - i(26), "weekdays" - i(1), "weekends" - i(1), "preferred day" - s("saturday"), "day preference %" - i(50), "mean time of visit (minutes after midnight)" - i(394), "standard deviation from mean" - i(279), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(50), "% pay cashier (instead of at pump)" - i(50), "payment method" - s("credit"), "preferred pump" - s("27LG"), "preferred pump %" - i(50)])).
car(177, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("66222AH"), "year" - i(2004), "month" - i(12), "day" - i(21), "hour" - i(19), "minute" - i(15), "station" - s("mobil"), "fill-ups" - i(4), "record history (days)" - i(126), "weekdays" - i(2), "weekends" - i(2), "preferred day" - s("sunday"), "day preference %" - i(50), "mean time of visit (minutes after midnight)" - i(181), "standard deviation from mean" - i(272), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(25), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(50)])).
car(178, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("2TNI815"), "year" - i(2005), "month" - i(1), "day" - i(28), "hour" - i(16), "minute" - i(14), "station" - s("mobil"), "fill-ups" - i(12), "record history (days)" - i(144), "weekdays" - i(12), "weekends" - i(0), "preferred day" - s("thursday"), "day preference %" - i(50), "mean time of visit (minutes after midnight)" - i(98), "standard deviation from mean" - i(298), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(91), "% pay cashier (instead of at pump)" - i(9), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(50)])).
car(179, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("4DNI403"), "year" - i(2005), "month" - i(2), "day" - i(28), "hour" - i(10), "minute" - i(46), "station" - s("mobil"), "fill-ups" - i(35), "record history (days)" - i(164), "weekdays" - i(31), "weekends" - i(4), "preferred day" - s("monday"), "day preference %" - i(25), "mean time of visit (minutes after midnight)" - i(20), "standard deviation from mean" - i(114), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(68), "% pay cashier (instead of at pump)" - i(5), "payment method" - s("credit"), "preferred pump" - s("47HG"), "preferred pump %" - i(20)])).
car(180, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("5443RHI"), "year" - i(2005), "month" - i(3), "day" - i(2), "hour" - i(21), "minute" - i(33), "station" - s("mobil"), "fill-ups" - i(53), "record history (days)" - i(148), "weekdays" - i(39), "weekends" - i(14), "preferred day" - s("thursday"), "day preference %" - i(18), "mean time of visit (minutes after midnight)" - i(22), "standard deviation from mean" - i(155), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(5), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(47)])).
car(181, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("1081AHI"), "year" - i(2005), "month" - i(1), "day" - i(23), "hour" - i(14), "minute" - i(1), "station" - s("mobil"), "fill-ups" - i(9), "record history (days)" - i(112), "weekdays" - i(5), "weekends" - i(4), "preferred day" - s("sunday"), "day preference %" - i(44), "mean time of visit (minutes after midnight)" - i(97), "standard deviation from mean" - i(261), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(22), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(44)])).
car(182, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("7234RHI"), "year" - i(2005), "month" - i(3), "day" - i(4), "hour" - i(1), "minute" - i(34), "station" - s("mobil"), "fill-ups" - i(119), "record history (days)" - i(149), "weekdays" - i(91), "weekends" - i(28), "preferred day" - s("saturday"), "day preference %" - i(20), "mean time of visit (minutes after midnight)" - i(11), "standard deviation from mean" - i(124), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(99), "% pay cashier (instead of at pump)" - i(3), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(22)])).
car(183, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("VOQ1266"), "year" - i(2005), "month" - i(3), "day" - i(3), "hour" - i(23), "minute" - i(6), "station" - s("mobil"), "fill-ups" - i(52), "record history (days)" - i(148), "weekdays" - i(38), "weekends" - i(14), "preferred day" - s("wednesday"), "day preference %" - i(21), "mean time of visit (minutes after midnight)" - i(1), "standard deviation from mean" - i(10), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(6), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(53)])).
car(184, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("7SNI876"), "year" - i(2004), "month" - i(10), "day" - i(13), "hour" - i(21), "minute" - i(39), "station" - s("mobil"), "fill-ups" - i(12), "record history (days)" - i(140), "weekdays" - i(11), "weekends" - i(1), "preferred day" - s("monday"), "day preference %" - i(41), "mean time of visit (minutes after midnight)" - i(104), "standard deviation from mean" - i(330), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(91), "% pay cashier (instead of at pump)" - i(16), "payment method" - s("credit"), "preferred pump" - s("27HG"), "preferred pump %" - i(33)])).
car(185, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("5VNI876"), "year" - i(2005), "month" - i(3), "day" - i(4), "hour" - i(8), "minute" - i(58), "station" - s("mobil"), "fill-ups" - i(129), "record history (days)" - i(93), "weekdays" - i(92), "weekends" - i(37), "preferred day" - s("monday"), "day preference %" - i(17), "mean time of visit (minutes after midnight)" - i(9), "standard deviation from mean" - i(104), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(67), "% pay cashier (instead of at pump)" - i(3), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(17)])).
car(186, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("9CNI867"), "year" - i(2005), "month" - i(2), "day" - i(1), "hour" - i(12), "minute" - i(22), "station" - s("mobil"), "fill-ups" - i(40), "record history (days)" - i(147), "weekdays" - i(23), "weekends" - i(17), "preferred day" - s("sunday"), "day preference %" - i(25), "mean time of visit (minutes after midnight)" - i(34), "standard deviation from mean" - i(216), "different locations" - i(2), "preferred station" - s("shell"), "preferred station %" - i(65), "% pay cashier (instead of at pump)" - i(5), "payment method" - s("credit"), "preferred pump" - s("97LG"), "preferred pump %" - i(40)])).
car(187, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("3VNI958"), "year" - i(2005), "month" - i(2), "day" - i(10), "hour" - i(18), "minute" - i(16), "station" - s("mobil"), "fill-ups" - i(33), "record history (days)" - i(147), "weekdays" - i(26), "weekends" - i(7), "preferred day" - s("tuesday"), "day preference %" - i(18), "mean time of visit (minutes after midnight)" - i(27), "standard deviation from mean" - i(148), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(93), "% pay cashier (instead of at pump)" - i(12), "payment method" - s("credit"), "preferred pump" - s("27HG"), "preferred pump %" - i(24)])).
car(188, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("0BNI962"), "year" - i(2004), "month" - i(11), "day" - i(11), "hour" - i(19), "minute" - i(46), "station" - s("shell"), "fill-ups" - i(19), "record history (days)" - i(148), "weekdays" - i(16), "weekends" - i(3), "preferred day" - s("monday"), "day preference %" - i(26), "mean time of visit (minutes after midnight)" - i(2), "standard deviation from mean" - i(11), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(94), "% pay cashier (instead of at pump)" - i(10), "payment method" - s("credit"), "preferred pump" - s("47HG"), "preferred pump %" - i(26)])).
car(189, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("0ENI962"), "year" - i(2004), "month" - i(12), "day" - i(12), "hour" - i(21), "minute" - i(33), "station" - s("mobil"), "fill-ups" - i(23), "record history (days)" - i(113), "weekdays" - i(17), "weekends" - i(6), "preferred day" - s("friday"), "day preference %" - i(21), "mean time of visit (minutes after midnight)" - i(44), "standard deviation from mean" - i(199), "different locations" - i(3), "preferred station" - s("mobil"), "preferred station %" - i(73), "% pay cashier (instead of at pump)" - i(9), "payment method" - s("credit"), "preferred pump" - s("47HG"), "preferred pump %" - i(30)])).
car(190, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("4BNI162"), "year" - i(2005), "month" - i(2), "day" - i(3), "hour" - i(11), "minute" - i(12), "station" - s("mobil"), "fill-ups" - i(32), "record history (days)" - i(137), "weekdays" - i(25), "weekends" - i(7), "preferred day" - s("tuesday"), "day preference %" - i(21), "mean time of visit (minutes after midnight)" - i(23), "standard deviation from mean" - i(125), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(6), "payment method" - s("credit"), "preferred pump" - s("37HG"), "preferred pump %" - i(34)])).
car(191, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("35582BH"), "year" - i(2004), "month" - i(12), "day" - i(15), "hour" - i(10), "minute" - i(17), "station" - s("mobil"), "fill-ups" - i(23), "record history (days)" - i(144), "weekdays" - i(23), "weekends" - i(0), "preferred day" - s("wednesday"), "day preference %" - i(39), "mean time of visit (minutes after midnight)" - i(31), "standard deviation from mean" - i(140), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(91), "% pay cashier (instead of at pump)" - i(9), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(21)])).
car(192, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("3ZNI333"), "year" - i(2005), "month" - i(3), "day" - i(3), "hour" - i(23), "minute" - i(56), "station" - s("mobil"), "fill-ups" - i(76), "record history (days)" - i(171), "weekdays" - i(45), "weekends" - i(31), "preferred day" - s("sunday"), "day preference %" - i(22), "mean time of visit (minutes after midnight)" - i(18), "standard deviation from mean" - i(151), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(5), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(72)])).
car(193, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("7ZNI403"), "year" - i(2005), "month" - i(2), "day" - i(27), "hour" - i(8), "minute" - i(32), "station" - s("mobil"), "fill-ups" - i(23), "record history (days)" - i(158), "weekdays" - i(12), "weekends" - i(11), "preferred day" - s("sunday"), "day preference %" - i(39), "mean time of visit (minutes after midnight)" - i(37), "standard deviation from mean" - i(167), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(9), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(52)])).
car(194, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("3WNI310"), "year" - i(2005), "month" - i(2), "day" - i(27), "hour" - i(10), "minute" - i(47), "station" - s("mobil"), "fill-ups" - i(11), "record history (days)" - i(164), "weekdays" - i(6), "weekends" - i(5), "preferred day" - s("sunday"), "day preference %" - i(27), "mean time of visit (minutes after midnight)" - i(72), "standard deviation from mean" - i(218), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(81), "% pay cashier (instead of at pump)" - i(9), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(27)])).
car(195, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("7871VJE"), "year" - i(2005), "month" - i(1), "day" - i(24), "hour" - i(14), "minute" - i(33), "station" - s("mobil"), "fill-ups" - i(11), "record history (days)" - i(129), "weekdays" - i(10), "weekends" - i(1), "preferred day" - s("tuesday"), "day preference %" - i(36), "mean time of visit (minutes after midnight)" - i(3), "standard deviation from mean" - i(10), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(81), "% pay cashier (instead of at pump)" - i(20), "payment method" - s("credit"), "preferred pump" - s("27HG"), "preferred pump %" - i(27)])).
car(196, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("4BNI382"), "year" - i(2005), "month" - i(1), "day" - i(26), "hour" - i(7), "minute" - i(28), "station" - s("mobil"), "fill-ups" - i(13), "record history (days)" - i(138), "weekdays" - i(13), "weekends" - i(0), "preferred day" - s("wednesday"), "day preference %" - i(23), "mean time of visit (minutes after midnight)" - i(43), "standard deviation from mean" - i(137), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(16), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(76)])).
car(197, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("8XNI277"), "year" - i(2005), "month" - i(3), "day" - i(1), "hour" - i(16), "minute" - i(32), "station" - s("mobil"), "fill-ups" - i(12), "record history (days)" - i(166), "weekdays" - i(10), "weekends" - i(2), "preferred day" - s("tuesday"), "day preference %" - i(25), "mean time of visit (minutes after midnight)" - i(69), "standard deviation from mean" - i(210), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(18), "payment method" - s("credit"), "preferred pump" - s("37HG"), "preferred pump %" - i(25)])).
car(198, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("5ZNI781"), "year" - i(2005), "month" - i(3), "day" - i(3), "hour" - i(15), "minute" - i(24), "station" - s("mobil"), "fill-ups" - i(115), "record history (days)" - i(171), "weekdays" - i(85), "weekends" - i(30), "preferred day" - s("friday"), "day preference %" - i(18), "mean time of visit (minutes after midnight)" - i(8), "standard deviation from mean" - i(87), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(93), "% pay cashier (instead of at pump)" - i(3), "payment method" - s("credit"), "preferred pump" - s("47HG"), "preferred pump %" - i(27)])).
car(199, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("5VNI991"), "year" - i(2005), "month" - i(1), "day" - i(30), "hour" - i(10), "minute" - i(10), "station" - s("mobil"), "fill-ups" - i(29), "record history (days)" - i(145), "weekdays" - i(8), "weekends" - i(21), "preferred day" - s("sunday"), "day preference %" - i(41), "mean time of visit (minutes after midnight)" - i(49), "standard deviation from mean" - i(253), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(93), "% pay cashier (instead of at pump)" - i(7), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(55)])).
car(200, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("7XNI159"), "year" - i(2005), "month" - i(3), "day" - i(3), "hour" - i(15), "minute" - i(1), "station" - s("mobil"), "fill-ups" - i(25), "record history (days)" - i(162), "weekdays" - i(14), "weekends" - i(11), "preferred day" - s("thursday"), "day preference %" - i(28), "mean time of visit (minutes after midnight)" - i(44), "standard deviation from mean" - i(202), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(88), "% pay cashier (instead of at pump)" - i(8), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(36)])).
car(201, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("25350BH"), "year" - i(2005), "month" - i(3), "day" - i(4), "hour" - i(12), "minute" - i(9), "station" - s("shell"), "fill-ups" - i(112), "record history (days)" - i(149), "weekdays" - i(95), "weekends" - i(17), "preferred day" - s("wednesday"), "day preference %" - i(18), "mean time of visit (minutes after midnight)" - i(1), "standard deviation from mean" - i(11), "different locations" - i(2), "preferred station" - s("shell"), "preferred station %" - i(91), "% pay cashier (instead of at pump)" - i(3), "payment method" - s("credit"), "preferred pump" - s("27LG"), "preferred pump %" - i(33)])).
car(202, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("5DNI384"), "year" - i(2005), "month" - i(3), "day" - i(1), "hour" - i(17), "minute" - i(41), "station" - s("mobil"), "fill-ups" - i(29), "record history (days)" - i(158), "weekdays" - i(28), "weekends" - i(1), "preferred day" - s("friday"), "day preference %" - i(27), "mean time of visit (minutes after midnight)" - i(29), "standard deviation from mean" - i(146), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(93), "% pay cashier (instead of at pump)" - i(7), "payment method" - s("credit"), "preferred pump" - s("27HG"), "preferred pump %" - i(31)])).
car(203, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("2UUB140"), "year" - i(2004), "month" - i(5), "day" - i(28), "hour" - i(19), "minute" - i(31), "station" - s("mobil"), "fill-ups" - i(12), "record history (days)" - i(85), "weekdays" - i(10), "weekends" - i(2), "preferred day" - s("friday"), "day preference %" - i(25), "mean time of visit (minutes after midnight)" - i(97), "standard deviation from mean" - i(309), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(8), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(58)])).
car(204, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("8XNI569"), "year" - i(2005), "month" - i(2), "day" - i(28), "hour" - i(23), "minute" - i(45), "station" - s("mobil"), "fill-ups" - i(58), "record history (days)" - i(157), "weekdays" - i(53), "weekends" - i(5), "preferred day" - s("monday"), "day preference %" - i(25), "mean time of visit (minutes after midnight)" - i(17), "standard deviation from mean" - i(125), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(5), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(31)])).
car(205, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("0WNI399"), "year" - i(2005), "month" - i(3), "day" - i(3), "hour" - i(13), "minute" - i(25), "station" - s("mobil"), "fill-ups" - i(35), "record history (days)" - i(169), "weekdays" - i(25), "weekends" - i(10), "preferred day" - s("thursday"), "day preference %" - i(20), "mean time of visit (minutes after midnight)" - i(20), "standard deviation from mean" - i(115), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(85), "% pay cashier (instead of at pump)" - i(5), "payment method" - s("credit"), "preferred pump" - s("37HG"), "preferred pump %" - i(20)])).
car(206, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("39434BH"), "year" - i(2005), "month" - i(1), "day" - i(19), "hour" - i(12), "minute" - i(49), "station" - s("mobil"), "fill-ups" - i(31), "record history (days)" - i(148), "weekdays" - i(28), "weekends" - i(3), "preferred day" - s("wednesday"), "day preference %" - i(22), "mean time of visit (minutes after midnight)" - i(39), "standard deviation from mean" - i(204), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(83), "% pay cashier (instead of at pump)" - i(6), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(22)])).
car(207, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("6XNI501"), "year" - i(2005), "month" - i(3), "day" - i(1), "hour" - i(17), "minute" - i(50), "station" - s("mobil"), "fill-ups" - i(24), "record history (days)" - i(153), "weekdays" - i(20), "weekends" - i(4), "preferred day" - s("tuesday"), "day preference %" - i(29), "mean time of visit (minutes after midnight)" - i(61), "standard deviation from mean" - i(276), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(9), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(70)])).
car(208, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("2CNI690"), "year" - i(2005), "month" - i(2), "day" - i(15), "hour" - i(13), "minute" - i(49), "station" - s("Cumberland Farms"), "fill-ups" - i(16), "record history (days)" - i(146), "weekdays" - i(9), "weekends" - i(7), "preferred day" - s("sunday"), "day preference %" - i(31), "mean time of visit (minutes after midnight)" - i(66), "standard deviation from mean" - i(212), "different locations" - i(3), "preferred station" - s("mobil"), "preferred station %" - i(81), "% pay cashier (instead of at pump)" - i(16), "payment method" - s("credit"), "preferred pump" - s("27HG"), "preferred pump %" - i(25)])).
car(209, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("13004AH"), "year" - i(2004), "month" - i(6), "day" - i(15), "hour" - i(13), "minute" - i(53), "station" - s("mobil"), "fill-ups" - i(4), "record history (days)" - i(20), "weekdays" - i(4), "weekends" - i(0), "preferred day" - s("friday"), "day preference %" - i(50), "mean time of visit (minutes after midnight)" - i(15), "standard deviation from mean" - i(23), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(25), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(25)])).
car(210, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("4BNI586"), "year" - i(2005), "month" - i(1), "day" - i(30), "hour" - i(16), "minute" - i(37), "station" - s("shell"), "fill-ups" - i(46), "record history (days)" - i(148), "weekdays" - i(35), "weekends" - i(11), "preferred day" - s("tuesday"), "day preference %" - i(34), "mean time of visit (minutes after midnight)" - i(26), "standard deviation from mean" - i(169), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(63), "% pay cashier (instead of at pump)" - i(4), "payment method" - s("credit"), "preferred pump" - s("07LG"), "preferred pump %" - i(15)])).
car(211, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("6072DA"), "year" - i(2005), "month" - i(2), "day" - i(24), "hour" - i(19), "minute" - i(38), "station" - s("bp"), "fill-ups" - i(8), "record history (days)" - i(130), "weekdays" - i(6), "weekends" - i(2), "preferred day" - s("thursday"), "day preference %" - i(37), "mean time of visit (minutes after midnight)" - i(114), "standard deviation from mean" - i(282), "different locations" - i(3), "preferred station" - s("mobil"), "preferred station %" - i(62), "% pay cashier (instead of at pump)" - i(12), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(50)])).
car(212, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("1394DA"), "year" - i(2005), "month" - i(1), "day" - i(11), "hour" - i(14), "minute" - i(7), "station" - s("bp"), "fill-ups" - i(2), "record history (days)" - i(72), "weekdays" - i(1), "weekends" - i(1), "preferred day" - s("tuesday"), "day preference %" - i(50), "mean time of visit (minutes after midnight)" - i(460), "standard deviation from mean" - i(325), "different locations" - i(2), "preferred station" - s("bp"), "preferred station %" - i(50), "% pay cashier (instead of at pump)" - i(50), "payment method" - s("credit"), "preferred pump" - s("27VM"), "preferred pump %" - i(50)])).
car(213, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("1605DA"), "year" - i(2004), "month" - i(11), "day" - i(18), "hour" - i(8), "minute" - i(56), "station" - s("amoco"), "fill-ups" - i(6), "record history (days)" - i(137), "weekdays" - i(4), "weekends" - i(2), "preferred day" - s("tuesday"), "day preference %" - i(33), "mean time of visit (minutes after midnight)" - i(125), "standard deviation from mean" - i(257), "different locations" - i(2), "preferred station" - s("shell"), "preferred station %" - i(83), "% pay cashier (instead of at pump)" - i(16), "payment method" - s("credit"), "preferred pump" - s("07LG"), "preferred pump %" - i(50)])).
car(214, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("9JNI937"), "year" - i(2005), "month" - i(3), "day" - i(3), "hour" - i(13), "minute" - i(19), "station" - s("mobil"), "fill-ups" - i(5), "record history (days)" - i(32), "weekdays" - i(4), "weekends" - i(1), "preferred day" - s("wednesday"), "day preference %" - i(40), "mean time of visit (minutes after midnight)" - i(111), "standard deviation from mean" - i(200), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(20), "payment method" - s("credit"), "preferred pump" - s("27HG"), "preferred pump %" - i(60)])).
car(215, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("6DNI895"), "year" - i(2005), "month" - i(3), "day" - i(1), "hour" - i(15), "minute" - i(38), "station" - s("mobil"), "fill-ups" - i(114), "record history (days)" - i(146), "weekdays" - i(89), "weekends" - i(25), "preferred day" - s("monday"), "day preference %" - i(17), "mean time of visit (minutes after midnight)" - i(10), "standard deviation from mean" - i(109), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(98), "% pay cashier (instead of at pump)" - i(5), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(42)])).
car(216, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("5FNI201"), "year" - i(2005), "month" - i(2), "day" - i(15), "hour" - i(19), "minute" - i(49), "station" - s("citgo"), "fill-ups" - i(37), "record history (days)" - i(151), "weekdays" - i(29), "weekends" - i(8), "preferred day" - s("tuesday"), "day preference %" - i(32), "mean time of visit (minutes after midnight)" - i(21), "standard deviation from mean" - i(126), "different locations" - i(3), "preferred station" - s("shell"), "preferred station %" - i(70), "% pay cashier (instead of at pump)" - i(8), "payment method" - s("credit"), "preferred pump" - s("27LG"), "preferred pump %" - i(21)])).
car(217, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("59110DH"), "year" - i(2005), "month" - i(3), "day" - i(1), "hour" - i(16), "minute" - i(58), "station" - s("mobil"), "fill-ups" - i(27), "record history (days)" - i(164), "weekdays" - i(25), "weekends" - i(2), "preferred day" - s("tuesday"), "day preference %" - i(59), "mean time of visit (minutes after midnight)" - i(54), "standard deviation from mean" - i(257), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(92), "% pay cashier (instead of at pump)" - i(8), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(55)])).
car(218, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("4257SHI"), "year" - i(2005), "month" - i(1), "day" - i(8), "hour" - i(20), "minute" - i(2), "station" - s("mobil"), "fill-ups" - i(6), "record history (days)" - i(135), "weekdays" - i(4), "weekends" - i(2), "preferred day" - s("monday"), "day preference %" - i(50), "mean time of visit (minutes after midnight)" - i(130), "standard deviation from mean" - i(266), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(83), "% pay cashier (instead of at pump)" - i(16), "payment method" - s("credit"), "preferred pump" - s("27HG"), "preferred pump %" - i(66)])).
car(219, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("5ZNI964"), "year" - i(2005), "month" - i(2), "day" - i(25), "hour" - i(14), "minute" - i(47), "station" - s("mobil"), "fill-ups" - i(53), "record history (days)" - i(160), "weekdays" - i(37), "weekends" - i(16), "preferred day" - s("tuesday"), "day preference %" - i(16), "mean time of visit (minutes after midnight)" - i(19), "standard deviation from mean" - i(136), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(96), "% pay cashier (instead of at pump)" - i(6), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(33)])).
car(220, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("6973RHI"), "year" - i(2005), "month" - i(2), "day" - i(21), "hour" - i(22), "minute" - i(32), "station" - s("mobil"), "fill-ups" - i(29), "record history (days)" - i(158), "weekdays" - i(20), "weekends" - i(9), "preferred day" - s("saturday"), "day preference %" - i(31), "mean time of visit (minutes after midnight)" - i(42), "standard deviation from mean" - i(214), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(7), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(24)])).
car(221, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("7VNI872"), "year" - i(2005), "month" - i(1), "day" - i(5), "hour" - i(7), "minute" - i(10), "station" - s("mobil"), "fill-ups" - i(36), "record history (days)" - i(146), "weekdays" - i(16), "weekends" - i(20), "preferred day" - s("saturday"), "day preference %" - i(33), "mean time of visit (minutes after midnight)" - i(15), "standard deviation from mean" - i(89), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(5), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(44)])).
car(222, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("6915MJM"), "year" - i(2005), "month" - i(3), "day" - i(3), "hour" - i(17), "minute" - i(24), "station" - s("mobil"), "fill-ups" - i(26), "record history (days)" - i(138), "weekdays" - i(15), "weekends" - i(11), "preferred day" - s("saturday"), "day preference %" - i(26), "mean time of visit (minutes after midnight)" - i(33), "standard deviation from mean" - i(158), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(8), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(57)])).
car(223, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("9175MJM"), "year" - i(2005), "month" - i(2), "day" - i(28), "hour" - i(18), "minute" - i(58), "station" - s("mobil"), "fill-ups" - i(90), "record history (days)" - i(143), "weekdays" - i(75), "weekends" - i(15), "preferred day" - s("wednesday"), "day preference %" - i(22), "mean time of visit (minutes after midnight)" - i(11), "standard deviation from mean" - i(106), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(95), "% pay cashier (instead of at pump)" - i(4), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(34)])).
car(224, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("4684NJM"), "year" - i(2005), "month" - i(3), "day" - i(3), "hour" - i(19), "minute" - i(51), "station" - s("mobil"), "fill-ups" - i(54), "record history (days)" - i(171), "weekdays" - i(32), "weekends" - i(22), "preferred day" - s("saturday"), "day preference %" - i(25), "mean time of visit (minutes after midnight)" - i(25), "standard deviation from mean" - i(184), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(70), "% pay cashier (instead of at pump)" - i(5), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(25)])).
car(225, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("6VNI878"), "year" - i(2005), "month" - i(3), "day" - i(3), "hour" - i(15), "minute" - i(54), "station" - s("mobil"), "fill-ups" - i(40), "record history (days)" - i(168), "weekdays" - i(23), "weekends" - i(17), "preferred day" - s("sunday"), "day preference %" - i(27), "mean time of visit (minutes after midnight)" - i(16), "standard deviation from mean" - i(101), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(7), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(52)])).
car(226, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("9893VII"), "year" - i(2005), "month" - i(1), "day" - i(8), "hour" - i(13), "minute" - i(6), "station" - s("mobil"), "fill-ups" - i(6), "record history (days)" - i(123), "weekdays" - i(0), "weekends" - i(6), "preferred day" - s("sunday"), "day preference %" - i(50), "mean time of visit (minutes after midnight)" - i(126), "standard deviation from mean" - i(258), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(66), "% pay cashier (instead of at pump)" - i(16), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(33)])).
car(227, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("6346HHI"), "year" - i(2005), "month" - i(3), "day" - i(3), "hour" - i(18), "minute" - i(47), "station" - s("mobil"), "fill-ups" - i(168), "record history (days)" - i(172), "weekdays" - i(123), "weekends" - i(45), "preferred day" - s("monday"), "day preference %" - i(17), "mean time of visit (minutes after midnight)" - i(0), "standard deviation from mean" - i(11), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(95), "% pay cashier (instead of at pump)" - i(3), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(28)])).
car(228, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("3982NHI"), "year" - i(2005), "month" - i(1), "day" - i(24), "hour" - i(14), "minute" - i(50), "station" - s("mobil"), "fill-ups" - i(13), "record history (days)" - i(132), "weekdays" - i(5), "weekends" - i(8), "preferred day" - s("saturday"), "day preference %" - i(61), "mean time of visit (minutes after midnight)" - i(112), "standard deviation from mean" - i(338), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(18), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(69)])).
car(229, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("2599DA"), "year" - i(2005), "month" - i(1), "day" - i(28), "hour" - i(13), "minute" - i(34), "station" - s("chevron"), "fill-ups" - i(4), "record history (days)" - i(21), "weekdays" - i(4), "weekends" - i(0), "preferred day" - s("friday"), "day preference %" - i(100), "mean time of visit (minutes after midnight)" - i(183), "standard deviation from mean" - i(275), "different locations" - i(2), "preferred station" - s("chevron"), "preferred station %" - i(75), "% pay cashier (instead of at pump)" - i(25), "payment method" - s("credit"), "preferred pump" - s("17YH"), "preferred pump %" - i(75)])).
car(230, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("2586LUI"), "year" - i(2004), "month" - i(8), "day" - i(8), "hour" - i(0), "minute" - i(52), "station" - s("mobil"), "fill-ups" - i(4), "record history (days)" - i(7), "weekdays" - i(0), "weekends" - i(4), "preferred day" - s("sunday"), "day preference %" - i(50), "mean time of visit (minutes after midnight)" - i(322), "standard deviation from mean" - i(484), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(25), "payment method" - s("credit"), "preferred pump" - s("37HG"), "preferred pump %" - i(50)])).
car(231, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("1614LJM"), "year" - i(2005), "month" - i(2), "day" - i(21), "hour" - i(17), "minute" - i(5), "station" - s("mobil"), "fill-ups" - i(9), "record history (days)" - i(138), "weekdays" - i(9), "weekends" - i(0), "preferred day" - s("wednesday"), "day preference %" - i(66), "mean time of visit (minutes after midnight)" - i(159), "standard deviation from mean" - i(425), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(88), "% pay cashier (instead of at pump)" - i(11), "payment method" - s("credit"), "preferred pump" - s("37HG"), "preferred pump %" - i(44)])).
car(232, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("8XNI362"), "year" - i(2005), "month" - i(1), "day" - i(8), "hour" - i(6), "minute" - i(57), "station" - s("mobil"), "fill-ups" - i(30), "record history (days)" - i(120), "weekdays" - i(19), "weekends" - i(11), "preferred day" - s("sunday"), "day preference %" - i(23), "mean time of visit (minutes after midnight)" - i(43), "standard deviation from mean" - i(229), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(96), "% pay cashier (instead of at pump)" - i(6), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(33)])).
car(233, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("3817HHI"), "year" - i(2005), "month" - i(2), "day" - i(11), "hour" - i(22), "minute" - i(33), "station" - s("shell"), "fill-ups" - i(30), "record history (days)" - i(147), "weekdays" - i(19), "weekends" - i(11), "preferred day" - s("saturday"), "day preference %" - i(23), "mean time of visit (minutes after midnight)" - i(31), "standard deviation from mean" - i(168), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(90), "% pay cashier (instead of at pump)" - i(6), "payment method" - s("credit"), "preferred pump" - s("47HG"), "preferred pump %" - i(53)])).
car(234, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("0064LJM"), "year" - i(2005), "month" - i(2), "day" - i(20), "hour" - i(15), "minute" - i(31), "station" - s("mobil"), "fill-ups" - i(26), "record history (days)" - i(177), "weekdays" - i(10), "weekends" - i(16), "preferred day" - s("saturday"), "day preference %" - i(34), "mean time of visit (minutes after midnight)" - i(47), "standard deviation from mean" - i(234), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(61), "% pay cashier (instead of at pump)" - i(7), "payment method" - s("credit"), "preferred pump" - s("97LG"), "preferred pump %" - i(34)])).
car(235, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("8CNI504"), "year" - i(2005), "month" - i(2), "day" - i(6), "hour" - i(12), "minute" - i(38), "station" - s("mobil"), "fill-ups" - i(54), "record history (days)" - i(148), "weekdays" - i(40), "weekends" - i(14), "preferred day" - s("thursday"), "day preference %" - i(18), "mean time of visit (minutes after midnight)" - i(24), "standard deviation from mean" - i(171), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(92), "% pay cashier (instead of at pump)" - i(5), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(27)])).
car(236, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("2WNI884"), "year" - i(2005), "month" - i(3), "day" - i(2), "hour" - i(19), "minute" - i(5), "station" - s("mobil"), "fill-ups" - i(39), "record history (days)" - i(147), "weekdays" - i(23), "weekends" - i(16), "preferred day" - s("sunday"), "day preference %" - i(25), "mean time of visit (minutes after midnight)" - i(1), "standard deviation from mean" - i(8), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(97), "% pay cashier (instead of at pump)" - i(5), "payment method" - s("credit"), "preferred pump" - s("37HG"), "preferred pump %" - i(25)])).
car(237, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("7875DA"), "year" - i(2004), "month" - i(12), "day" - i(19), "hour" - i(11), "minute" - i(50), "station" - s("mobil"), "fill-ups" - i(6), "record history (days)" - i(123), "weekdays" - i(2), "weekends" - i(4), "preferred day" - s("saturday"), "day preference %" - i(50), "mean time of visit (minutes after midnight)" - i(165), "standard deviation from mean" - i(338), "different locations" - i(4), "preferred station" - s("mobil"), "preferred station %" - i(50), "% pay cashier (instead of at pump)" - i(16), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(33)])).
car(238, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("8ENI866"), "year" - i(2005), "month" - i(1), "day" - i(29), "hour" - i(9), "minute" - i(51), "station" - s("mobil"), "fill-ups" - i(82), "record history (days)" - i(148), "weekdays" - i(59), "weekends" - i(23), "preferred day" - s("thursday"), "day preference %" - i(19), "mean time of visit (minutes after midnight)" - i(0), "standard deviation from mean" - i(3), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(95), "% pay cashier (instead of at pump)" - i(6), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(60)])).
car(239, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("7CNI528"), "year" - i(2004), "month" - i(12), "day" - i(10), "hour" - i(8), "minute" - i(31), "station" - s("mobil"), "fill-ups" - i(31), "record history (days)" - i(145), "weekdays" - i(25), "weekends" - i(6), "preferred day" - s("friday"), "day preference %" - i(41), "mean time of visit (minutes after midnight)" - i(23), "standard deviation from mean" - i(126), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(9), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(45)])).
car(240, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("6ENI151"), "year" - i(2005), "month" - i(2), "day" - i(3), "hour" - i(14), "minute" - i(2), "station" - s("shell"), "fill-ups" - i(14), "record history (days)" - i(147), "weekdays" - i(9), "weekends" - i(5), "preferred day" - s("sunday"), "day preference %" - i(28), "mean time of visit (minutes after midnight)" - i(99), "standard deviation from mean" - i(345), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(50), "% pay cashier (instead of at pump)" - i(7), "payment method" - s("credit"), "preferred pump" - s("97LG"), "preferred pump %" - i(35)])).
car(241, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("7TNI551"), "year" - i(2005), "month" - i(3), "day" - i(1), "hour" - i(23), "minute" - i(29), "station" - s("mobil"), "fill-ups" - i(32), "record history (days)" - i(166), "weekdays" - i(19), "weekends" - i(13), "preferred day" - s("sunday"), "day preference %" - i(21), "mean time of visit (minutes after midnight)" - i(28), "standard deviation from mean" - i(154), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(6), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(50)])).
car(242, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("91673AH"), "year" - i(2005), "month" - i(3), "day" - i(3), "hour" - i(11), "minute" - i(53), "station" - s("shell"), "fill-ups" - i(90), "record history (days)" - i(171), "weekdays" - i(79), "weekends" - i(11), "preferred day" - s("friday"), "day preference %" - i(24), "mean time of visit (minutes after midnight)" - i(8), "standard deviation from mean" - i(83), "different locations" - i(3), "preferred station" - s("shell"), "preferred station %" - i(81), "% pay cashier (instead of at pump)" - i(4), "payment method" - s("credit"), "preferred pump" - s("27LG"), "preferred pump %" - i(26)])).
car(243, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("73354AH"), "year" - i(2004), "month" - i(11), "day" - i(30), "hour" - i(10), "minute" - i(12), "station" - s("shell"), "fill-ups" - i(16), "record history (days)" - i(72), "weekdays" - i(16), "weekends" - i(0), "preferred day" - s("wednesday"), "day preference %" - i(43), "mean time of visit (minutes after midnight)" - i(61), "standard deviation from mean" - i(223), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(87), "% pay cashier (instead of at pump)" - i(13), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(31)])).
car(244, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("63454AH"), "year" - i(2005), "month" - i(3), "day" - i(2), "hour" - i(14), "minute" - i(1), "station" - s("shell"), "fill-ups" - i(2), "record history (days)" - i(19), "weekdays" - i(1), "weekends" - i(1), "preferred day" - s("saturday"), "day preference %" - i(50), "mean time of visit (minutes after midnight)" - i(488), "standard deviation from mean" - i(346), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(50), "% pay cashier (instead of at pump)" - i(50), "payment method" - s("credit"), "preferred pump" - s("27LG"), "preferred pump %" - i(50)])).
car(245, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("04454AH"), "year" - i(2005), "month" - i(2), "day" - i(20), "hour" - i(23), "minute" - i(54), "station" - s("mobil"), "fill-ups" - i(19), "record history (days)" - i(158), "weekdays" - i(14), "weekends" - i(5), "preferred day" - s("wednesday"), "day preference %" - i(31), "mean time of visit (minutes after midnight)" - i(0), "standard deviation from mean" - i(2), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(52), "% pay cashier (instead of at pump)" - i(10), "payment method" - s("credit"), "preferred pump" - s("97LG"), "preferred pump %" - i(26)])).
car(246, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("82965AH"), "year" - i(2005), "month" - i(1), "day" - i(13), "hour" - i(22), "minute" - i(15), "station" - s("shell"), "fill-ups" - i(17), "record history (days)" - i(135), "weekdays" - i(14), "weekends" - i(3), "preferred day" - s("thursday"), "day preference %" - i(47), "mean time of visit (minutes after midnight)" - i(62), "standard deviation from mean" - i(233), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(58), "% pay cashier (instead of at pump)" - i(6), "payment method" - s("credit"), "preferred pump" - s("27HG"), "preferred pump %" - i(23)])).
car(247, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("75756AH"), "year" - i(2005), "month" - i(3), "day" - i(3), "hour" - i(22), "minute" - i(23), "station" - s("mobil"), "fill-ups" - i(108), "record history (days)" - i(149), "weekdays" - i(89), "weekends" - i(19), "preferred day" - s("tuesday"), "day preference %" - i(24), "mean time of visit (minutes after midnight)" - i(11), "standard deviation from mean" - i(119), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(96), "% pay cashier (instead of at pump)" - i(2), "payment method" - s("credit"), "preferred pump" - s("47HG"), "preferred pump %" - i(24)])).
car(248, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("15166AH"), "year" - i(2005), "month" - i(3), "day" - i(2), "hour" - i(10), "minute" - i(34), "station" - s("mobil"), "fill-ups" - i(24), "record history (days)" - i(167), "weekdays" - i(15), "weekends" - i(9), "preferred day" - s("wednesday"), "day preference %" - i(25), "mean time of visit (minutes after midnight)" - i(26), "standard deviation from mean" - i(118), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(95), "% pay cashier (instead of at pump)" - i(9), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(41)])).
car(249, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("41018BH"), "year" - i(2005), "month" - i(1), "day" - i(14), "hour" - i(13), "minute" - i(26), "station" - s("mobil"), "fill-ups" - i(6), "record history (days)" - i(143), "weekdays" - i(1), "weekends" - i(5), "preferred day" - s("saturday"), "day preference %" - i(50), "mean time of visit (minutes after midnight)" - i(19), "standard deviation from mean" - i(34), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(20), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(50)])).
car(250, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("68128BH"), "year" - i(2004), "month" - i(7), "day" - i(12), "hour" - i(19), "minute" - i(35), "station" - s("mobil"), "fill-ups" - i(4), "record history (days)" - i(79), "weekdays" - i(2), "weekends" - i(2), "preferred day" - s("saturday"), "day preference %" - i(50), "mean time of visit (minutes after midnight)" - i(207), "standard deviation from mean" - i(311), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(25), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(50)])).
car(251, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("52389BH"), "year" - i(2005), "month" - i(3), "day" - i(4), "hour" - i(12), "minute" - i(1), "station" - s("shell"), "fill-ups" - i(75), "record history (days)" - i(149), "weekdays" - i(51), "weekends" - i(24), "preferred day" - s("sunday"), "day preference %" - i(21), "mean time of visit (minutes after midnight)" - i(13), "standard deviation from mean" - i(116), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(73), "% pay cashier (instead of at pump)" - i(4), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(24)])).
car(252, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("67300BH"), "year" - i(2004), "month" - i(12), "day" - i(2), "hour" - i(19), "minute" - i(6), "station" - s("mobil"), "fill-ups" - i(2), "record history (days)" - i(100), "weekdays" - i(2), "weekends" - i(0), "preferred day" - s("wednesday"), "day preference %" - i(50), "mean time of visit (minutes after midnight)" - i(539), "standard deviation from mean" - i(381), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(50), "payment method" - s("credit"), "preferred pump" - s("27HG"), "preferred pump %" - i(50)])).
car(253, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("19020BH"), "year" - i(2005), "month" - i(1), "day" - i(22), "hour" - i(11), "minute" - i(17), "station" - s("mobil"), "fill-ups" - i(5), "record history (days)" - i(131), "weekdays" - i(2), "weekends" - i(3), "preferred day" - s("saturday"), "day preference %" - i(60), "mean time of visit (minutes after midnight)" - i(255), "standard deviation from mean" - i(457), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(20), "payment method" - s("credit"), "preferred pump" - s("27HG"), "preferred pump %" - i(60)])).
car(254, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("66382BH"), "year" - i(2005), "month" - i(1), "day" - i(28), "hour" - i(11), "minute" - i(2), "station" - s("mobil"), "fill-ups" - i(60), "record history (days)" - i(147), "weekdays" - i(50), "weekends" - i(10), "preferred day" - s("friday"), "day preference %" - i(21), "mean time of visit (minutes after midnight)" - i(13), "standard deviation from mean" - i(100), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(5), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(86)])).
car(255, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("65812BH"), "year" - i(2004), "month" - i(9), "day" - i(30), "hour" - i(10), "minute" - i(9), "station" - s("mobil"), "fill-ups" - i(9), "record history (days)" - i(147), "weekdays" - i(7), "weekends" - i(2), "preferred day" - s("thursday"), "day preference %" - i(33), "mean time of visit (minutes after midnight)" - i(79), "standard deviation from mean" - i(212), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(55), "% pay cashier (instead of at pump)" - i(22), "payment method" - s("credit"), "preferred pump" - s("47HG"), "preferred pump %" - i(33)])).
car(256, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("91342BH"), "year" - i(2004), "month" - i(11), "day" - i(12), "hour" - i(20), "minute" - i(24), "station" - s("mobil"), "fill-ups" - i(5), "record history (days)" - i(34), "weekdays" - i(1), "weekends" - i(4), "preferred day" - s("sunday"), "day preference %" - i(40), "mean time of visit (minutes after midnight)" - i(268), "standard deviation from mean" - i(481), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(80), "% pay cashier (instead of at pump)" - i(20), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(40)])).
car(257, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("51983BH"), "year" - i(2004), "month" - i(10), "day" - i(30), "hour" - i(19), "minute" - i(38), "station" - s("mobil"), "fill-ups" - i(3), "record history (days)" - i(148), "weekdays" - i(2), "weekends" - i(1), "preferred day" - s("wednesday"), "day preference %" - i(66), "mean time of visit (minutes after midnight)" - i(276), "standard deviation from mean" - i(319), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(66), "% pay cashier (instead of at pump)" - i(33), "payment method" - s("credit"), "preferred pump" - s("27HG"), "preferred pump %" - i(66)])).
car(258, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("29203BH"), "year" - i(2005), "month" - i(2), "day" - i(6), "hour" - i(11), "minute" - i(42), "station" - s("shell"), "fill-ups" - i(23), "record history (days)" - i(142), "weekdays" - i(16), "weekends" - i(7), "preferred day" - s("wednesday"), "day preference %" - i(26), "mean time of visit (minutes after midnight)" - i(51), "standard deviation from mean" - i(223), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(82), "% pay cashier (instead of at pump)" - i(9), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(26)])).
car(259, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("99203BH"), "year" - i(2005), "month" - i(3), "day" - i(3), "hour" - i(13), "minute" - i(18), "station" - s("shell"), "fill-ups" - i(25), "record history (days)" - i(166), "weekdays" - i(20), "weekends" - i(5), "preferred day" - s("tuesday"), "day preference %" - i(32), "mean time of visit (minutes after midnight)" - i(37), "standard deviation from mean" - i(171), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(84), "% pay cashier (instead of at pump)" - i(8), "payment method" - s("credit"), "preferred pump" - s("47HG"), "preferred pump %" - i(44)])).
car(260, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("98323BH"), "year" - i(2005), "month" - i(1), "day" - i(25), "hour" - i(13), "minute" - i(11), "station" - s("shell"), "fill-ups" - i(10), "record history (days)" - i(144), "weekdays" - i(5), "weekends" - i(5), "preferred day" - s("sunday"), "day preference %" - i(30), "mean time of visit (minutes after midnight)" - i(116), "standard deviation from mean" - i(331), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(80), "% pay cashier (instead of at pump)" - i(20), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(30)])).
car(261, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("20523BH"), "year" - i(2004), "month" - i(10), "day" - i(14), "hour" - i(22), "minute" - i(36), "station" - s("mobil"), "fill-ups" - i(19), "record history (days)" - i(145), "weekdays" - i(6), "weekends" - i(13), "preferred day" - s("saturday"), "day preference %" - i(63), "mean time of visit (minutes after midnight)" - i(31), "standard deviation from mean" - i(125), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(73), "% pay cashier (instead of at pump)" - i(11), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(21)])).
car(262, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("42866BH"), "year" - i(2005), "month" - i(3), "day" - i(3), "hour" - i(22), "minute" - i(28), "station" - s("mobil"), "fill-ups" - i(159), "record history (days)" - i(149), "weekdays" - i(127), "weekends" - i(32), "preferred day" - s("wednesday"), "day preference %" - i(19), "mean time of visit (minutes after midnight)" - i(6), "standard deviation from mean" - i(83), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(51), "% pay cashier (instead of at pump)" - i(2), "payment method" - s("credit"), "preferred pump" - s("27LG"), "preferred pump %" - i(12)])).
car(263, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("58808DH"), "year" - i(2004), "month" - i(8), "day" - i(21), "hour" - i(14), "minute" - i(58), "station" - s("shell"), "fill-ups" - i(3), "record history (days)" - i(54), "weekdays" - i(1), "weekends" - i(2), "preferred day" - s("saturday"), "day preference %" - i(66), "mean time of visit (minutes after midnight)" - i(361), "standard deviation from mean" - i(418), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(66), "% pay cashier (instead of at pump)" - i(33), "payment method" - s("credit"), "preferred pump" - s("17LG"), "preferred pump %" - i(33)])).
car(264, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("57519DH"), "year" - i(2005), "month" - i(2), "day" - i(15), "hour" - i(11), "minute" - i(40), "station" - s("mobil"), "fill-ups" - i(43), "record history (days)" - i(147), "weekdays" - i(35), "weekends" - i(8), "preferred day" - s("tuesday"), "day preference %" - i(23), "mean time of visit (minutes after midnight)" - i(24), "standard deviation from mean" - i(154), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(76), "% pay cashier (instead of at pump)" - i(7), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(30)])).
car(265, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("55719DH"), "year" - i(2005), "month" - i(2), "day" - i(7), "hour" - i(11), "minute" - i(33), "station" - s("shell"), "fill-ups" - i(99), "record history (days)" - i(147), "weekdays" - i(78), "weekends" - i(21), "preferred day" - s("monday"), "day preference %" - i(19), "mean time of visit (minutes after midnight)" - i(7), "standard deviation from mean" - i(74), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(59), "% pay cashier (instead of at pump)" - i(3), "payment method" - s("credit"), "preferred pump" - s("07LG"), "preferred pump %" - i(17)])).
car(266, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("12129DH"), "year" - i(2005), "month" - i(2), "day" - i(6), "hour" - i(12), "minute" - i(16), "station" - s("mobil"), "fill-ups" - i(16), "record history (days)" - i(119), "weekdays" - i(5), "weekends" - i(11), "preferred day" - s("sunday"), "day preference %" - i(43), "mean time of visit (minutes after midnight)" - i(36), "standard deviation from mean" - i(132), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(13), "payment method" - s("credit"), "preferred pump" - s("37HG"), "preferred pump %" - i(43)])).
car(267, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("15159DH"), "year" - i(2005), "month" - i(2), "day" - i(19), "hour" - i(12), "minute" - i(41), "station" - s("mobil"), "fill-ups" - i(5), "record history (days)" - i(132), "weekdays" - i(0), "weekends" - i(5), "preferred day" - s("saturday"), "day preference %" - i(80), "mean time of visit (minutes after midnight)" - i(196), "standard deviation from mean" - i(352), "different locations" - i(3), "preferred station" - s("pilot"), "preferred station %" - i(60), "% pay cashier (instead of at pump)" - i(20), "payment method" - s("credit"), "preferred pump" - s("27XG"), "preferred pump %" - i(40)])).
car(268, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("25169DH"), "year" - i(2005), "month" - i(3), "day" - i(2), "hour" - i(14), "minute" - i(22), "station" - s("mobil"), "fill-ups" - i(84), "record history (days)" - i(166), "weekdays" - i(76), "weekends" - i(8), "preferred day" - s("wednesday"), "day preference %" - i(22), "mean time of visit (minutes after midnight)" - i(14), "standard deviation from mean" - i(125), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(5), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(32)])).
car(269, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("91930DH"), "year" - i(2005), "month" - i(1), "day" - i(8), "hour" - i(6), "minute" - i(9), "station" - s("mobil"), "fill-ups" - i(5), "record history (days)" - i(46), "weekdays" - i(3), "weekends" - i(2), "preferred day" - s("tuesday"), "day preference %" - i(60), "mean time of visit (minutes after midnight)" - i(195), "standard deviation from mean" - i(351), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(80), "% pay cashier (instead of at pump)" - i(20), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(40)])).
car(270, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("2DNI616"), "year" - i(2005), "month" - i(2), "day" - i(27), "hour" - i(12), "minute" - i(23), "station" - s("shell"), "fill-ups" - i(39), "record history (days)" - i(163), "weekdays" - i(28), "weekends" - i(11), "preferred day" - s("friday"), "day preference %" - i(25), "mean time of visit (minutes after midnight)" - i(27), "standard deviation from mean" - i(162), "different locations" - i(3), "preferred station" - s("mobil"), "preferred station %" - i(76), "% pay cashier (instead of at pump)" - i(5), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(20)])).
car(271, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("8ENI726"), "year" - i(2005), "month" - i(3), "day" - i(1), "hour" - i(16), "minute" - i(41), "station" - s("mobil"), "fill-ups" - i(37), "record history (days)" - i(123), "weekdays" - i(29), "weekends" - i(8), "preferred day" - s("tuesday"), "day preference %" - i(18), "mean time of visit (minutes after midnight)" - i(30), "standard deviation from mean" - i(177), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(94), "% pay cashier (instead of at pump)" - i(8), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(27)])).
car(272, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("4VNI798"), "year" - i(2005), "month" - i(1), "day" - i(23), "hour" - i(18), "minute" - i(36), "station" - s("mobil"), "fill-ups" - i(9), "record history (days)" - i(103), "weekdays" - i(6), "weekends" - i(3), "preferred day" - s("sunday"), "day preference %" - i(33), "mean time of visit (minutes after midnight)" - i(102), "standard deviation from mean" - i(232), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(14), "payment method" - s("credit"), "preferred pump" - s("37HG"), "preferred pump %" - i(33)])).
car(273, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("1556ZII"), "year" - i(2005), "month" - i(3), "day" - i(3), "hour" - i(22), "minute" - i(55), "station" - s("shell"), "fill-ups" - i(28), "record history (days)" - i(148), "weekdays" - i(20), "weekends" - i(8), "preferred day" - s("thursday"), "day preference %" - i(25), "mean time of visit (minutes after midnight)" - i(35), "standard deviation from mean" - i(181), "different locations" - i(3), "preferred station" - s("mobil"), "preferred station %" - i(50), "% pay cashier (instead of at pump)" - i(7), "payment method" - s("credit"), "preferred pump" - s("97LG"), "preferred pump %" - i(25)])).
car(274, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("2KPD746"), "year" - i(2005), "month" - i(3), "day" - i(4), "hour" - i(13), "minute" - i(7), "station" - s("mobil"), "fill-ups" - i(109), "record history (days)" - i(168), "weekdays" - i(80), "weekends" - i(29), "preferred day" - s("tuesday"), "day preference %" - i(17), "mean time of visit (minutes after midnight)" - i(5), "standard deviation from mean" - i(58), "different locations" - i(2), "preferred station" - s("shell"), "preferred station %" - i(68), "% pay cashier (instead of at pump)" - i(3), "payment method" - s("credit"), "preferred pump" - s("97LG"), "preferred pump %" - i(22)])).
car(275, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("5796HHI"), "year" - i(2005), "month" - i(2), "day" - i(13), "hour" - i(22), "minute" - i(31), "station" - s("Cumberland Farms"), "fill-ups" - i(27), "record history (days)" - i(150), "weekdays" - i(21), "weekends" - i(6), "preferred day" - s("wednesday"), "day preference %" - i(25), "mean time of visit (minutes after midnight)" - i(51), "standard deviation from mean" - i(240), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(96), "% pay cashier (instead of at pump)" - i(8), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(22)])).
car(276, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("AF585"), "year" - i(2005), "month" - i(1), "day" - i(29), "hour" - i(18), "minute" - i(0), "station" - s("shell"), "fill-ups" - i(120), "record history (days)" - i(148), "weekdays" - i(105), "weekends" - i(15), "preferred day" - s("wednesday"), "day preference %" - i(20), "mean time of visit (minutes after midnight)" - i(7), "standard deviation from mean" - i(76), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(59), "% pay cashier (instead of at pump)" - i(4), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(20)])).
car(277, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("5ZNI096"), "year" - i(2005), "month" - i(3), "day" - i(3), "hour" - i(13), "minute" - i(7), "station" - s("shell"), "fill-ups" - i(62), "record history (days)" - i(164), "weekdays" - i(49), "weekends" - i(13), "preferred day" - s("thursday"), "day preference %" - i(24), "mean time of visit (minutes after midnight)" - i(15), "standard deviation from mean" - i(117), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(79), "% pay cashier (instead of at pump)" - i(5), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(27)])).
car(278, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("4576YHI"), "year" - i(2005), "month" - i(2), "day" - i(23), "hour" - i(19), "minute" - i(17), "station" - s("mobil"), "fill-ups" - i(35), "record history (days)" - i(159), "weekdays" - i(15), "weekends" - i(20), "preferred day" - s("sunday"), "day preference %" - i(40), "mean time of visit (minutes after midnight)" - i(38), "standard deviation from mean" - i(220), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(8), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(37)])).
car(279, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("5032QHI"), "year" - i(2004), "month" - i(4), "day" - i(6), "hour" - i(22), "minute" - i(8), "station" - s("mobil"), "fill-ups" - i(3), "record history (days)" - i(32), "weekdays" - i(3), "weekends" - i(0), "preferred day" - s("friday"), "day preference %" - i(66), "mean time of visit (minutes after midnight)" - i(447), "standard deviation from mean" - i(517), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(33), "payment method" - s("credit"), "preferred pump" - s("27HG"), "preferred pump %" - i(66)])).
car(280, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("8556WII"), "year" - i(2004), "month" - i(12), "day" - i(22), "hour" - i(0), "minute" - i(16), "station" - s("mobil"), "fill-ups" - i(2), "record history (days)" - i(99), "weekdays" - i(1), "weekends" - i(1), "preferred day" - s("thursday"), "day preference %" - i(50), "mean time of visit (minutes after midnight)" - i(561), "standard deviation from mean" - i(397), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(50), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(50)])).
car(281, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("5732AHI"), "year" - i(2005), "month" - i(1), "day" - i(18), "hour" - i(18), "minute" - i(20), "station" - s("mobil"), "fill-ups" - i(5), "record history (days)" - i(123), "weekdays" - i(2), "weekends" - i(3), "preferred day" - s("sunday"), "day preference %" - i(40), "mean time of visit (minutes after midnight)" - i(234), "standard deviation from mean" - i(420), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(20), "payment method" - s("credit"), "preferred pump" - s("27HG"), "preferred pump %" - i(40)])).
car(282, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("1676DA"), "year" - i(2005), "month" - i(2), "day" - i(18), "hour" - i(0), "minute" - i(8), "station" - s("mobil"), "fill-ups" - i(19), "record history (days)" - i(134), "weekdays" - i(13), "weekends" - i(6), "preferred day" - s("saturday"), "day preference %" - i(26), "mean time of visit (minutes after midnight)" - i(48), "standard deviation from mean" - i(198), "different locations" - i(3), "preferred station" - s("mobil"), "preferred station %" - i(52), "% pay cashier (instead of at pump)" - i(10), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(36)])).
car(283, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("63819AH"), "year" - i(2005), "month" - i(1), "day" - i(15), "hour" - i(11), "minute" - i(22), "station" - s("mobil"), "fill-ups" - i(2), "record history (days)" - i(34), "weekdays" - i(0), "weekends" - i(2), "preferred day" - s("sunday"), "day preference %" - i(50), "mean time of visit (minutes after midnight)" - i(567), "standard deviation from mean" - i(401), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(50), "payment method" - s("credit"), "preferred pump" - s("37HG"), "preferred pump %" - i(50)])).
car(284, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("80709AH"), "year" - i(2005), "month" - i(3), "day" - i(2), "hour" - i(23), "minute" - i(54), "station" - s("mobil"), "fill-ups" - i(26), "record history (days)" - i(148), "weekdays" - i(18), "weekends" - i(8), "preferred day" - s("tuesday"), "day preference %" - i(26), "mean time of visit (minutes after midnight)" - i(48), "standard deviation from mean" - i(227), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(96), "% pay cashier (instead of at pump)" - i(8), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(65)])).
car(285, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("7367MHI"), "year" - i(2005), "month" - i(2), "day" - i(7), "hour" - i(17), "minute" - i(14), "station" - s("mobil"), "fill-ups" - i(31), "record history (days)" - i(148), "weekdays" - i(22), "weekends" - i(9), "preferred day" - s("saturday"), "day preference %" - i(19), "mean time of visit (minutes after midnight)" - i(42), "standard deviation from mean" - i(231), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(87), "% pay cashier (instead of at pump)" - i(6), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(35)])).
car(286, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("0DNI369"), "year" - i(2005), "month" - i(3), "day" - i(3), "hour" - i(11), "minute" - i(8), "station" - s("shell"), "fill-ups" - i(23), "record history (days)" - i(162), "weekdays" - i(18), "weekends" - i(5), "preferred day" - s("wednesday"), "day preference %" - i(30), "mean time of visit (minutes after midnight)" - i(24), "standard deviation from mean" - i(110), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(52), "% pay cashier (instead of at pump)" - i(8), "payment method" - s("credit"), "preferred pump" - s("17LG"), "preferred pump %" - i(26)])).
car(287, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("7TNI469"), "year" - i(2005), "month" - i(2), "day" - i(15), "hour" - i(10), "minute" - i(23), "station" - s("shell"), "fill-ups" - i(19), "record history (days)" - i(148), "weekdays" - i(17), "weekends" - i(2), "preferred day" - s("tuesday"), "day preference %" - i(36), "mean time of visit (minutes after midnight)" - i(40), "standard deviation from mean" - i(169), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(63), "% pay cashier (instead of at pump)" - i(10), "payment method" - s("credit"), "preferred pump" - s("27HG"), "preferred pump %" - i(21)])).
car(288, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("5FNI669"), "year" - i(2005), "month" - i(2), "day" - i(14), "hour" - i(1), "minute" - i(9), "station" - s("mobil"), "fill-ups" - i(44), "record history (days)" - i(151), "weekdays" - i(35), "weekends" - i(9), "preferred day" - s("tuesday"), "day preference %" - i(29), "mean time of visit (minutes after midnight)" - i(0), "standard deviation from mean" - i(4), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(95), "% pay cashier (instead of at pump)" - i(4), "payment method" - s("credit"), "preferred pump" - s("27HG"), "preferred pump %" - i(29)])).
car(289, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("7VNI450"), "year" - i(2005), "month" - i(2), "day" - i(14), "hour" - i(19), "minute" - i(7), "station" - s("mobil"), "fill-ups" - i(26), "record history (days)" - i(144), "weekdays" - i(14), "weekends" - i(12), "preferred day" - s("sunday"), "day preference %" - i(34), "mean time of visit (minutes after midnight)" - i(55), "standard deviation from mean" - i(260), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(12), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(69)])).
car(290, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("56567HQ"), "year" - i(2004), "month" - i(3), "day" - i(17), "hour" - i(18), "minute" - i(33), "station" - s("mobil"), "fill-ups" - i(3), "record history (days)" - i(13), "weekdays" - i(3), "weekends" - i(0), "preferred day" - s("wednesday"), "day preference %" - i(33), "mean time of visit (minutes after midnight)" - i(258), "standard deviation from mean" - i(299), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(33), "payment method" - s("credit"), "preferred pump" - s("47HG"), "preferred pump %" - i(33)])).
car(291, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("61866HQ"), "year" - i(2005), "month" - i(2), "day" - i(3), "hour" - i(14), "minute" - i(55), "station" - s("mobil"), "fill-ups" - i(9), "record history (days)" - i(117), "weekdays" - i(9), "weekends" - i(0), "preferred day" - s("tuesday"), "day preference %" - i(33), "mean time of visit (minutes after midnight)" - i(133), "standard deviation from mean" - i(356), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(55), "% pay cashier (instead of at pump)" - i(22), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(33)])).
car(292, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("8XNI371"), "year" - i(2005), "month" - i(2), "day" - i(6), "hour" - i(16), "minute" - i(40), "station" - s("shell"), "fill-ups" - i(4), "record history (days)" - i(141), "weekdays" - i(1), "weekends" - i(3), "preferred day" - s("sunday"), "day preference %" - i(50), "mean time of visit (minutes after midnight)" - i(348), "standard deviation from mean" - i(522), "different locations" - i(1), "preferred station" - s("shell"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(25), "payment method" - s("credit"), "preferred pump" - s("07LG"), "preferred pump %" - i(50)])).
car(293, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("8ZNI729"), "year" - i(2005), "month" - i(3), "day" - i(1), "hour" - i(17), "minute" - i(0), "station" - s("mobil"), "fill-ups" - i(35), "record history (days)" - i(146), "weekdays" - i(29), "weekends" - i(6), "preferred day" - s("tuesday"), "day preference %" - i(34), "mean time of visit (minutes after midnight)" - i(31), "standard deviation from mean" - i(179), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(80), "% pay cashier (instead of at pump)" - i(5), "payment method" - s("credit"), "preferred pump" - s("27HG"), "preferred pump %" - i(22)])).
car(294, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("2DNI969"), "year" - i(2005), "month" - i(1), "day" - i(18), "hour" - i(17), "minute" - i(58), "station" - s("mobil"), "fill-ups" - i(9), "record history (days)" - i(121), "weekdays" - i(8), "weekends" - i(1), "preferred day" - s("thursday"), "day preference %" - i(33), "mean time of visit (minutes after midnight)" - i(91), "standard deviation from mean" - i(243), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(11), "payment method" - s("credit"), "preferred pump" - s("27HG"), "preferred pump %" - i(33)])).
car(295, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("8FNI134"), "year" - i(2005), "month" - i(3), "day" - i(4), "hour" - i(13), "minute" - i(16), "station" - s("mobil"), "fill-ups" - i(28), "record history (days)" - i(117), "weekdays" - i(20), "weekends" - i(8), "preferred day" - s("tuesday"), "day preference %" - i(21), "mean time of visit (minutes after midnight)" - i(31), "standard deviation from mean" - i(160), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(7), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(25)])).
car(296, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("9DNI864"), "year" - i(2005), "month" - i(2), "day" - i(18), "hour" - i(14), "minute" - i(48), "station" - s("mobil"), "fill-ups" - i(14), "record history (days)" - i(149), "weekdays" - i(10), "weekends" - i(4), "preferred day" - s("wednesday"), "day preference %" - i(28), "mean time of visit (minutes after midnight)" - i(108), "standard deviation from mean" - i(361), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(85), "% pay cashier (instead of at pump)" - i(15), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(28)])).
car(297, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("6SNI503"), "year" - i(2005), "month" - i(2), "day" - i(27), "hour" - i(12), "minute" - i(51), "station" - s("mobil"), "fill-ups" - i(20), "record history (days)" - i(141), "weekdays" - i(14), "weekends" - i(6), "preferred day" - s("wednesday"), "day preference %" - i(20), "mean time of visit (minutes after midnight)" - i(75), "standard deviation from mean" - i(304), "different locations" - i(3), "preferred station" - s("mobil"), "preferred station %" - i(85), "% pay cashier (instead of at pump)" - i(11), "payment method" - s("credit"), "preferred pump" - s("47HG"), "preferred pump %" - i(30)])).
car(298, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("5JNI774"), "year" - i(2005), "month" - i(3), "day" - i(4), "hour" - i(12), "minute" - i(52), "station" - s("mobil"), "fill-ups" - i(20), "record history (days)" - i(42), "weekdays" - i(15), "weekends" - i(5), "preferred day" - s("monday"), "day preference %" - i(25), "mean time of visit (minutes after midnight)" - i(53), "standard deviation from mean" - i(226), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(95), "% pay cashier (instead of at pump)" - i(10), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(35)])).
car(299, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("0YNI639"), "year" - i(2005), "month" - i(2), "day" - i(17), "hour" - i(19), "minute" - i(33), "station" - s("mobil"), "fill-ups" - i(79), "record history (days)" - i(132), "weekdays" - i(67), "weekends" - i(12), "preferred day" - s("wednesday"), "day preference %" - i(20), "mean time of visit (minutes after midnight)" - i(13), "standard deviation from mean" - i(114), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(98), "% pay cashier (instead of at pump)" - i(4), "payment method" - s("credit"), "preferred pump" - s("27HG"), "preferred pump %" - i(29)])).
car(300, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("8CNI849"), "year" - i(2005), "month" - i(2), "day" - i(5), "hour" - i(20), "minute" - i(24), "station" - s("shell"), "fill-ups" - i(22), "record history (days)" - i(146), "weekdays" - i(12), "weekends" - i(10), "preferred day" - s("saturday"), "day preference %" - i(27), "mean time of visit (minutes after midnight)" - i(60), "standard deviation from mean" - i(264), "different locations" - i(2), "preferred station" - s("shell"), "preferred station %" - i(68), "% pay cashier (instead of at pump)" - i(9), "payment method" - s("credit"), "preferred pump" - s("27LG"), "preferred pump %" - i(27)])).
car(301, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("8CNI149"), "year" - i(2005), "month" - i(2), "day" - i(13), "hour" - i(18), "minute" - i(52), "station" - s("mobil"), "fill-ups" - i(25), "record history (days)" - i(144), "weekdays" - i(5), "weekends" - i(20), "preferred day" - s("saturday"), "day preference %" - i(48), "mean time of visit (minutes after midnight)" - i(49), "standard deviation from mean" - i(237), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(92), "% pay cashier (instead of at pump)" - i(8), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(20)])).
car(302, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("3UNI549"), "year" - i(2005), "month" - i(2), "day" - i(23), "hour" - i(17), "minute" - i(46), "station" - s("mobil"), "fill-ups" - i(29), "record history (days)" - i(178), "weekdays" - i(25), "weekends" - i(4), "preferred day" - s("wednesday"), "day preference %" - i(34), "mean time of visit (minutes after midnight)" - i(44), "standard deviation from mean" - i(219), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(96), "% pay cashier (instead of at pump)" - i(7), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(27)])).
car(303, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("2UNI022"), "year" - i(2005), "month" - i(2), "day" - i(25), "hour" - i(17), "minute" - i(55), "station" - s("shell"), "fill-ups" - i(8), "record history (days)" - i(96), "weekdays" - i(6), "weekends" - i(2), "preferred day" - s("thursday"), "day preference %" - i(37), "mean time of visit (minutes after midnight)" - i(177), "standard deviation from mean" - i(438), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(62), "% pay cashier (instead of at pump)" - i(12), "payment method" - s("credit"), "preferred pump" - s("27HG"), "preferred pump %" - i(37)])).
car(304, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("0DNI022"), "year" - i(2005), "month" - i(2), "day" - i(15), "hour" - i(19), "minute" - i(46), "station" - s("mobil"), "fill-ups" - i(30), "record history (days)" - i(148), "weekdays" - i(17), "weekends" - i(13), "preferred day" - s("sunday"), "day preference %" - i(26), "mean time of visit (minutes after midnight)" - i(1), "standard deviation from mean" - i(9), "different locations" - i(4), "preferred station" - s("mobil"), "preferred station %" - i(80), "% pay cashier (instead of at pump)" - i(8), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(43)])).
car(305, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("8ENI136"), "year" - i(2004), "month" - i(11), "day" - i(25), "hour" - i(13), "minute" - i(19), "station" - s("sheetz"), "fill-ups" - i(14), "record history (days)" - i(143), "weekdays" - i(9), "weekends" - i(5), "preferred day" - s("thursday"), "day preference %" - i(42), "mean time of visit (minutes after midnight)" - i(98), "standard deviation from mean" - i(342), "different locations" - i(3), "preferred station" - s("mobil"), "preferred station %" - i(78), "% pay cashier (instead of at pump)" - i(14), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(21)])).
car(306, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("5260AII"), "year" - i(2005), "month" - i(2), "day" - i(27), "hour" - i(12), "minute" - i(54), "station" - s("mobil"), "fill-ups" - i(17), "record history (days)" - i(136), "weekdays" - i(14), "weekends" - i(3), "preferred day" - s("thursday"), "day preference %" - i(29), "mean time of visit (minutes after midnight)" - i(63), "standard deviation from mean" - i(248), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(88), "% pay cashier (instead of at pump)" - i(11), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(47)])).
car(307, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("12229DH"), "year" - i(2005), "month" - i(3), "day" - i(3), "hour" - i(22), "minute" - i(26), "station" - s("mobil"), "fill-ups" - i(153), "record history (days)" - i(148), "weekdays" - i(120), "weekends" - i(33), "preferred day" - s("tuesday"), "day preference %" - i(16), "mean time of visit (minutes after midnight)" - i(9), "standard deviation from mean" - i(112), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(3), "payment method" - s("credit"), "preferred pump" - s("37HG"), "preferred pump %" - i(22)])).
car(308, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("7295NJM"), "year" - i(2005), "month" - i(2), "day" - i(25), "hour" - i(11), "minute" - i(38), "station" - s("mobil"), "fill-ups" - i(24), "record history (days)" - i(146), "weekdays" - i(18), "weekends" - i(6), "preferred day" - s("saturday"), "day preference %" - i(20), "mean time of visit (minutes after midnight)" - i(39), "standard deviation from mean" - i(186), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(75), "% pay cashier (instead of at pump)" - i(8), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(25)])).
car(309, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("9TNI044"), "year" - i(2005), "month" - i(3), "day" - i(4), "hour" - i(10), "minute" - i(52), "station" - s("shell"), "fill-ups" - i(82), "record history (days)" - i(173), "weekdays" - i(73), "weekends" - i(9), "preferred day" - s("wednesday"), "day preference %" - i(19), "mean time of visit (minutes after midnight)" - i(14), "standard deviation from mean" - i(124), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(63), "% pay cashier (instead of at pump)" - i(3), "payment method" - s("credit"), "preferred pump" - s("27HG"), "preferred pump %" - i(15)])).
car(310, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("7VNI002"), "year" - i(2005), "month" - i(3), "day" - i(1), "hour" - i(16), "minute" - i(37), "station" - s("mobil"), "fill-ups" - i(22), "record history (days)" - i(168), "weekdays" - i(18), "weekends" - i(4), "preferred day" - s("friday"), "day preference %" - i(27), "mean time of visit (minutes after midnight)" - i(34), "standard deviation from mean" - i(153), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(4), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(40)])).
car(311, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("3TNI917"), "year" - i(2005), "month" - i(3), "day" - i(1), "hour" - i(8), "minute" - i(58), "station" - s("mobil"), "fill-ups" - i(98), "record history (days)" - i(165), "weekdays" - i(91), "weekends" - i(7), "preferred day" - s("wednesday"), "day preference %" - i(22), "mean time of visit (minutes after midnight)" - i(7), "standard deviation from mean" - i(72), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(86), "% pay cashier (instead of at pump)" - i(3), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(28)])).
car(312, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("77456BH"), "year" - i(2004), "month" - i(10), "day" - i(27), "hour" - i(13), "minute" - i(35), "station" - s("mobil"), "fill-ups" - i(3), "record history (days)" - i(30), "weekdays" - i(3), "weekends" - i(0), "preferred day" - s("tuesday"), "day preference %" - i(66), "mean time of visit (minutes after midnight)" - i(294), "standard deviation from mean" - i(339), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(33), "payment method" - s("credit"), "preferred pump" - s("47HG"), "preferred pump %" - i(33)])).
car(313, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("0DNI195"), "year" - i(2005), "month" - i(3), "day" - i(4), "hour" - i(12), "minute" - i(38), "station" - s("mobil"), "fill-ups" - i(34), "record history (days)" - i(171), "weekdays" - i(18), "weekends" - i(16), "preferred day" - s("sunday"), "day preference %" - i(23), "mean time of visit (minutes after midnight)" - i(4), "standard deviation from mean" - i(26), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(52), "% pay cashier (instead of at pump)" - i(11), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(20)])).
car(314, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("1337YHI"), "year" - i(2005), "month" - i(2), "day" - i(28), "hour" - i(14), "minute" - i(49), "station" - s("shell"), "fill-ups" - i(83), "record history (days)" - i(165), "weekdays" - i(64), "weekends" - i(19), "preferred day" - s("thursday"), "day preference %" - i(26), "mean time of visit (minutes after midnight)" - i(11), "standard deviation from mean" - i(99), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(62), "% pay cashier (instead of at pump)" - i(5), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(14)])).
car(315, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("7034LJM"), "year" - i(2005), "month" - i(2), "day" - i(1), "hour" - i(13), "minute" - i(31), "station" - s("mobil"), "fill-ups" - i(6), "record history (days)" - i(74), "weekdays" - i(3), "weekends" - i(3), "preferred day" - s("sunday"), "day preference %" - i(33), "mean time of visit (minutes after midnight)" - i(118), "standard deviation from mean" - i(241), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(16), "payment method" - s("credit"), "preferred pump" - s("27HG"), "preferred pump %" - i(50)])).
car(316, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("5ZNI317"), "year" - i(2004), "month" - i(11), "day" - i(29), "hour" - i(12), "minute" - i(20), "station" - s("mobil"), "fill-ups" - i(7), "record history (days)" - i(147), "weekdays" - i(4), "weekends" - i(3), "preferred day" - s("thursday"), "day preference %" - i(28), "mean time of visit (minutes after midnight)" - i(110), "standard deviation from mean" - i(250), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(14), "payment method" - s("credit"), "preferred pump" - s("47HG"), "preferred pump %" - i(71)])).
car(317, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("5FNI834"), "year" - i(2005), "month" - i(3), "day" - i(3), "hour" - i(12), "minute" - i(3), "station" - s("mobil"), "fill-ups" - i(47), "record history (days)" - i(162), "weekdays" - i(28), "weekends" - i(19), "preferred day" - s("saturday"), "day preference %" - i(25), "mean time of visit (minutes after midnight)" - i(4), "standard deviation from mean" - i(32), "different locations" - i(3), "preferred station" - s("mobil"), "preferred station %" - i(63), "% pay cashier (instead of at pump)" - i(6), "payment method" - s("credit"), "preferred pump" - s("47HG"), "preferred pump %" - i(21)])).
car(318, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("46963DH"), "year" - i(2005), "month" - i(2), "day" - i(25), "hour" - i(22), "minute" - i(22), "station" - s("mobil"), "fill-ups" - i(7), "record history (days)" - i(33), "weekdays" - i(4), "weekends" - i(3), "preferred day" - s("sunday"), "day preference %" - i(28), "mean time of visit (minutes after midnight)" - i(188), "standard deviation from mean" - i(427), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(14), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(57)])).
car(319, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("4CNI591"), "year" - i(2005), "month" - i(3), "day" - i(4), "hour" - i(12), "minute" - i(17), "station" - s("shell"), "fill-ups" - i(45), "record history (days)" - i(171), "weekdays" - i(35), "weekends" - i(10), "preferred day" - s("monday"), "day preference %" - i(20), "mean time of visit (minutes after midnight)" - i(0), "standard deviation from mean" - i(3), "different locations" - i(3), "preferred station" - s("mobil"), "preferred station %" - i(77), "% pay cashier (instead of at pump)" - i(9), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(28)])).
car(320, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("5FNI163"), "year" - i(2005), "month" - i(2), "day" - i(16), "hour" - i(11), "minute" - i(41), "station" - s("mobil"), "fill-ups" - i(19), "record history (days)" - i(143), "weekdays" - i(8), "weekends" - i(11), "preferred day" - s("sunday"), "day preference %" - i(52), "mean time of visit (minutes after midnight)" - i(12), "standard deviation from mean" - i(50), "different locations" - i(3), "preferred station" - s("mobil"), "preferred station %" - i(84), "% pay cashier (instead of at pump)" - i(10), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(31)])).
car(321, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("6573RHI"), "year" - i(2004), "month" - i(8), "day" - i(29), "hour" - i(20), "minute" - i(3), "station" - s("mobil"), "fill-ups" - i(147), "record history (days)" - i(123), "weekdays" - i(84), "weekends" - i(63), "preferred day" - s("sunday"), "day preference %" - i(29), "mean time of visit (minutes after midnight)" - i(4), "standard deviation from mean" - i(56), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(54), "% pay cashier (instead of at pump)" - i(2), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(15)])).
car(322, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("5359III"), "year" - i(2005), "month" - i(2), "day" - i(28), "hour" - i(15), "minute" - i(5), "station" - s("mobil"), "fill-ups" - i(2), "record history (days)" - i(22), "weekdays" - i(1), "weekends" - i(1), "preferred day" - s("sunday"), "day preference %" - i(50), "mean time of visit (minutes after midnight)" - i(663), "standard deviation from mean" - i(469), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(50), "payment method" - s("credit"), "preferred pump" - s("27HG"), "preferred pump %" - i(100)])).
car(323, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("7VNI111"), "year" - i(2005), "month" - i(3), "day" - i(3), "hour" - i(9), "minute" - i(2), "station" - s("mobil"), "fill-ups" - i(101), "record history (days)" - i(170), "weekdays" - i(79), "weekends" - i(22), "preferred day" - s("thursday"), "day preference %" - i(20), "mean time of visit (minutes after midnight)" - i(10), "standard deviation from mean" - i(102), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(83), "% pay cashier (instead of at pump)" - i(4), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(23)])).
car(324, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("7XNI311"), "year" - i(2004), "month" - i(8), "day" - i(1), "hour" - i(1), "minute" - i(37), "station" - s("mobil"), "fill-ups" - i(67), "record history (days)" - i(133), "weekdays" - i(48), "weekends" - i(19), "preferred day" - s("sunday"), "day preference %" - i(19), "mean time of visit (minutes after midnight)" - i(9), "standard deviation from mean" - i(75), "different locations" - i(2), "preferred station" - s("shell"), "preferred station %" - i(52), "% pay cashier (instead of at pump)" - i(5), "payment method" - s("credit"), "preferred pump" - s("27LG"), "preferred pump %" - i(29)])).
car(325, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("0TNI107"), "year" - i(2005), "month" - i(1), "day" - i(24), "hour" - i(23), "minute" - i(41), "station" - s("mobil"), "fill-ups" - i(57), "record history (days)" - i(148), "weekdays" - i(47), "weekends" - i(10), "preferred day" - s("wednesday"), "day preference %" - i(22), "mean time of visit (minutes after midnight)" - i(23), "standard deviation from mean" - i(169), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(7), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(40)])).
car(326, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("1093DA"), "year" - i(2004), "month" - i(10), "day" - i(7), "hour" - i(12), "minute" - i(37), "station" - s("citgo"), "fill-ups" - i(13), "record history (days)" - i(150), "weekdays" - i(9), "weekends" - i(4), "preferred day" - s("tuesday"), "day preference %" - i(30), "mean time of visit (minutes after midnight)" - i(69), "standard deviation from mean" - i(231), "different locations" - i(4), "preferred station" - s("mobil"), "preferred station %" - i(61), "% pay cashier (instead of at pump)" - i(7), "payment method" - s("credit"), "preferred pump" - s("17LG"), "preferred pump %" - i(15)])).
car(327, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("2CNI408"), "year" - i(2005), "month" - i(2), "day" - i(19), "hour" - i(12), "minute" - i(10), "station" - s("mobil"), "fill-ups" - i(29), "record history (days)" - i(179), "weekdays" - i(25), "weekends" - i(4), "preferred day" - s("tuesday"), "day preference %" - i(31), "mean time of visit (minutes after midnight)" - i(31), "standard deviation from mean" - i(159), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(7), "payment method" - s("credit"), "preferred pump" - s("47HG"), "preferred pump %" - i(27)])).
car(328, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("7CNI718"), "year" - i(2005), "month" - i(2), "day" - i(13), "hour" - i(11), "minute" - i(18), "station" - s("mobil"), "fill-ups" - i(22), "record history (days)" - i(147), "weekdays" - i(12), "weekends" - i(10), "preferred day" - s("sunday"), "day preference %" - i(31), "mean time of visit (minutes after midnight)" - i(34), "standard deviation from mean" - i(150), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(95), "% pay cashier (instead of at pump)" - i(9), "payment method" - s("credit"), "preferred pump" - s("37HG"), "preferred pump %" - i(31)])).
car(329, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("12199"), "year" - i(2004), "month" - i(8), "day" - i(28), "hour" - i(19), "minute" - i(36), "station" - s("shell"), "fill-ups" - i(9), "record history (days)" - i(20), "weekdays" - i(7), "weekends" - i(2), "preferred day" - s("thursday"), "day preference %" - i(33), "mean time of visit (minutes after midnight)" - i(148), "standard deviation from mean" - i(397), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(88), "% pay cashier (instead of at pump)" - i(11), "payment method" - s("credit"), "preferred pump" - s("47HG"), "preferred pump %" - i(33)])).
car(330, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("4ZNI599"), "year" - i(2005), "month" - i(1), "day" - i(12), "hour" - i(11), "minute" - i(25), "station" - s("mobil"), "fill-ups" - i(33), "record history (days)" - i(147), "weekdays" - i(28), "weekends" - i(5), "preferred day" - s("wednesday"), "day preference %" - i(27), "mean time of visit (minutes after midnight)" - i(18), "standard deviation from mean" - i(101), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(93), "% pay cashier (instead of at pump)" - i(9), "payment method" - s("credit"), "preferred pump" - s("27HG"), "preferred pump %" - i(30)])).
car(331, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("9782RHI"), "year" - i(2005), "month" - i(3), "day" - i(3), "hour" - i(22), "minute" - i(12), "station" - s("mobil"), "fill-ups" - i(105), "record history (days)" - i(148), "weekdays" - i(91), "weekends" - i(14), "preferred day" - s("thursday"), "day preference %" - i(23), "mean time of visit (minutes after midnight)" - i(13), "standard deviation from mean" - i(134), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(84), "% pay cashier (instead of at pump)" - i(4), "payment method" - s("credit"), "preferred pump" - s("27HG"), "preferred pump %" - i(20)])).
car(332, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("5FNI214"), "year" - i(2005), "month" - i(1), "day" - i(21), "hour" - i(19), "minute" - i(18), "station" - s("mobil"), "fill-ups" - i(13), "record history (days)" - i(108), "weekdays" - i(12), "weekends" - i(1), "preferred day" - s("wednesday"), "day preference %" - i(23), "mean time of visit (minutes after midnight)" - i(46), "standard deviation from mean" - i(146), "different locations" - i(3), "preferred station" - s("shell"), "preferred station %" - i(61), "% pay cashier (instead of at pump)" - i(16), "payment method" - s("credit"), "preferred pump" - s("97LG"), "preferred pump %" - i(23)])).
car(333, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("20999BH"), "year" - i(2005), "month" - i(3), "day" - i(2), "hour" - i(13), "minute" - i(9), "station" - s("mobil"), "fill-ups" - i(26), "record history (days)" - i(168), "weekdays" - i(17), "weekends" - i(9), "preferred day" - s("saturday"), "day preference %" - i(30), "mean time of visit (minutes after midnight)" - i(23), "standard deviation from mean" - i(113), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(88), "% pay cashier (instead of at pump)" - i(7), "payment method" - s("credit"), "preferred pump" - s("47HG"), "preferred pump %" - i(23)])).
car(334, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("3762RHI"), "year" - i(2005), "month" - i(1), "day" - i(19), "hour" - i(15), "minute" - i(11), "station" - s("mobil"), "fill-ups" - i(34), "record history (days)" - i(145), "weekdays" - i(31), "weekends" - i(3), "preferred day" - s("wednesday"), "day preference %" - i(23), "mean time of visit (minutes after midnight)" - i(36), "standard deviation from mean" - i(201), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(85), "% pay cashier (instead of at pump)" - i(6), "payment method" - s("credit"), "preferred pump" - s("27HG"), "preferred pump %" - i(35)])).
car(335, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("7087DA"), "year" - i(2005), "month" - i(2), "day" - i(21), "hour" - i(20), "minute" - i(49), "station" - s("mobil"), "fill-ups" - i(6), "record history (days)" - i(136), "weekdays" - i(5), "weekends" - i(1), "preferred day" - s("thursday"), "day preference %" - i(33), "mean time of visit (minutes after midnight)" - i(121), "standard deviation from mean" - i(249), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(83), "% pay cashier (instead of at pump)" - i(16), "payment method" - s("credit"), "preferred pump" - s("27HG"), "preferred pump %" - i(33)])).
car(336, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("6SNI833"), "year" - i(2005), "month" - i(3), "day" - i(3), "hour" - i(17), "minute" - i(27), "station" - s("mobil"), "fill-ups" - i(31), "record history (days)" - i(162), "weekdays" - i(21), "weekends" - i(10), "preferred day" - s("monday"), "day preference %" - i(22), "mean time of visit (minutes after midnight)" - i(28), "standard deviation from mean" - i(153), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(93), "% pay cashier (instead of at pump)" - i(6), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(35)])).
car(337, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("58786AH"), "year" - i(2004), "month" - i(12), "day" - i(19), "hour" - i(19), "minute" - i(7), "station" - s("mobil"), "fill-ups" - i(6), "record history (days)" - i(145), "weekdays" - i(2), "weekends" - i(4), "preferred day" - s("sunday"), "day preference %" - i(33), "mean time of visit (minutes after midnight)" - i(113), "standard deviation from mean" - i(231), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(83), "% pay cashier (instead of at pump)" - i(16), "payment method" - s("credit"), "preferred pump" - s("37HG"), "preferred pump %" - i(50)])).
car(338, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("0XNI320"), "year" - i(2005), "month" - i(1), "day" - i(13), "hour" - i(21), "minute" - i(29), "station" - s("shell"), "fill-ups" - i(41), "record history (days)" - i(147), "weekdays" - i(31), "weekends" - i(10), "preferred day" - s("tuesday"), "day preference %" - i(19), "mean time of visit (minutes after midnight)" - i(18), "standard deviation from mean" - i(108), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(92), "% pay cashier (instead of at pump)" - i(5), "payment method" - s("credit"), "preferred pump" - s("37HG"), "preferred pump %" - i(26)])).
car(339, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("3215DA"), "year" - i(2005), "month" - i(2), "day" - i(15), "hour" - i(19), "minute" - i(1), "station" - s("crown"), "fill-ups" - i(3), "record history (days)" - i(99), "weekdays" - i(2), "weekends" - i(1), "preferred day" - s("tuesday"), "day preference %" - i(33), "mean time of visit (minutes after midnight)" - i(246), "standard deviation from mean" - i(284), "different locations" - i(3), "preferred station" - s("mobil"), "preferred station %" - i(33), "% pay cashier (instead of at pump)" - i(33), "payment method" - s("credit"), "preferred pump" - s("37GH"), "preferred pump %" - i(33)])).
car(340, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("9TNI250"), "year" - i(2005), "month" - i(3), "day" - i(4), "hour" - i(9), "minute" - i(2), "station" - s("mobil"), "fill-ups" - i(69), "record history (days)" - i(172), "weekdays" - i(43), "weekends" - i(26), "preferred day" - s("sunday"), "day preference %" - i(21), "mean time of visit (minutes after midnight)" - i(10), "standard deviation from mean" - i(80), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(95), "% pay cashier (instead of at pump)" - i(4), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(39)])).
car(341, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("9TNI451"), "year" - i(2005), "month" - i(2), "day" - i(15), "hour" - i(16), "minute" - i(21), "station" - s("mobil"), "fill-ups" - i(32), "record history (days)" - i(148), "weekdays" - i(24), "weekends" - i(8), "preferred day" - s("friday"), "day preference %" - i(40), "mean time of visit (minutes after midnight)" - i(21), "standard deviation from mean" - i(113), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(6), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(28)])).
car(342, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("0ZNI244"), "year" - i(2005), "month" - i(1), "day" - i(12), "hour" - i(15), "minute" - i(1), "station" - s("mobil"), "fill-ups" - i(6), "record history (days)" - i(111), "weekdays" - i(5), "weekends" - i(1), "preferred day" - s("thursday"), "day preference %" - i(50), "mean time of visit (minutes after midnight)" - i(120), "standard deviation from mean" - i(246), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(33), "payment method" - s("credit"), "preferred pump" - s("27HG"), "preferred pump %" - i(33)])).
car(343, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("7VNI754"), "year" - i(2005), "month" - i(2), "day" - i(7), "hour" - i(21), "minute" - i(15), "station" - s("mobil"), "fill-ups" - i(9), "record history (days)" - i(148), "weekdays" - i(7), "weekends" - i(2), "preferred day" - s("thursday"), "day preference %" - i(33), "mean time of visit (minutes after midnight)" - i(150), "standard deviation from mean" - i(401), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(22), "payment method" - s("credit"), "preferred pump" - s("47HG"), "preferred pump %" - i(33)])).
car(344, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("2VNI054"), "year" - i(2005), "month" - i(3), "day" - i(3), "hour" - i(21), "minute" - i(50), "station" - s("mobil"), "fill-ups" - i(96), "record history (days)" - i(170), "weekdays" - i(72), "weekends" - i(24), "preferred day" - s("tuesday"), "day preference %" - i(17), "mean time of visit (minutes after midnight)" - i(0), "standard deviation from mean" - i(5), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(87), "% pay cashier (instead of at pump)" - i(5), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(25)])).
car(345, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("0YNI154"), "year" - i(2005), "month" - i(1), "day" - i(24), "hour" - i(10), "minute" - i(36), "station" - s("mobil"), "fill-ups" - i(20), "record history (days)" - i(142), "weekdays" - i(17), "weekends" - i(3), "preferred day" - s("wednesday"), "day preference %" - i(20), "mean time of visit (minutes after midnight)" - i(1), "standard deviation from mean" - i(4), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(75), "% pay cashier (instead of at pump)" - i(10), "payment method" - s("credit"), "preferred pump" - s("97LG"), "preferred pump %" - i(20)])).
car(346, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("4DNI254"), "year" - i(2005), "month" - i(2), "day" - i(26), "hour" - i(10), "minute" - i(43), "station" - s("mobil"), "fill-ups" - i(32), "record history (days)" - i(140), "weekdays" - i(14), "weekends" - i(18), "preferred day" - s("saturday"), "day preference %" - i(43), "mean time of visit (minutes after midnight)" - i(36), "standard deviation from mean" - i(191), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(93), "% pay cashier (instead of at pump)" - i(6), "payment method" - s("credit"), "preferred pump" - s("27HG"), "preferred pump %" - i(21)])).
car(347, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("2UNI977"), "year" - i(2005), "month" - i(2), "day" - i(26), "hour" - i(20), "minute" - i(43), "station" - s("mobil"), "fill-ups" - i(30), "record history (days)" - i(155), "weekdays" - i(21), "weekends" - i(9), "preferred day" - s("saturday"), "day preference %" - i(20), "mean time of visit (minutes after midnight)" - i(39), "standard deviation from mean" - i(202), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(83), "% pay cashier (instead of at pump)" - i(7), "payment method" - s("credit"), "preferred pump" - s("47HG"), "preferred pump %" - i(33)])).
car(348, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("2TNI987"), "year" - i(2005), "month" - i(1), "day" - i(16), "hour" - i(9), "minute" - i(35), "station" - s("mobil"), "fill-ups" - i(37), "record history (days)" - i(144), "weekdays" - i(21), "weekends" - i(16), "preferred day" - s("sunday"), "day preference %" - i(27), "mean time of visit (minutes after midnight)" - i(39), "standard deviation from mean" - i(229), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(91), "% pay cashier (instead of at pump)" - i(5), "payment method" - s("credit"), "preferred pump" - s("27HG"), "preferred pump %" - i(32)])).
car(349, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("5VNI087"), "year" - i(2005), "month" - i(2), "day" - i(1), "hour" - i(11), "minute" - i(37), "station" - s("mobil"), "fill-ups" - i(20), "record history (days)" - i(139), "weekdays" - i(11), "weekends" - i(9), "preferred day" - s("saturday"), "day preference %" - i(25), "mean time of visit (minutes after midnight)" - i(54), "standard deviation from mean" - i(210), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(90), "% pay cashier (instead of at pump)" - i(11), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(35)])).
car(350, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("0TNI287"), "year" - i(2005), "month" - i(2), "day" - i(26), "hour" - i(16), "minute" - i(32), "station" - s("mobil"), "fill-ups" - i(62), "record history (days)" - i(163), "weekdays" - i(39), "weekends" - i(23), "preferred day" - s("saturday"), "day preference %" - i(19), "mean time of visit (minutes after midnight)" - i(21), "standard deviation from mean" - i(169), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(51), "% pay cashier (instead of at pump)" - i(8), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(30)])).
car(351, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("3VNI005"), "year" - i(2005), "month" - i(3), "day" - i(3), "hour" - i(11), "minute" - i(48), "station" - s("mobil"), "fill-ups" - i(57), "record history (days)" - i(172), "weekdays" - i(42), "weekends" - i(15), "preferred day" - s("tuesday"), "day preference %" - i(21), "mean time of visit (minutes after midnight)" - i(22), "standard deviation from mean" - i(164), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(98), "% pay cashier (instead of at pump)" - i(3), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(26)])).
car(352, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("8ZNI205"), "year" - i(2004), "month" - i(12), "day" - i(28), "hour" - i(21), "minute" - i(33), "station" - s("mobil"), "fill-ups" - i(31), "record history (days)" - i(147), "weekdays" - i(21), "weekends" - i(10), "preferred day" - s("tuesday"), "day preference %" - i(35), "mean time of visit (minutes after midnight)" - i(25), "standard deviation from mean" - i(135), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(80), "% pay cashier (instead of at pump)" - i(3), "payment method" - s("credit"), "preferred pump" - s("47HG"), "preferred pump %" - i(25)])).
car(353, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("3UNI505"), "year" - i(2005), "month" - i(2), "day" - i(9), "hour" - i(18), "minute" - i(9), "station" - s("mobil"), "fill-ups" - i(53), "record history (days)" - i(142), "weekdays" - i(45), "weekends" - i(8), "preferred day" - s("wednesday"), "day preference %" - i(28), "mean time of visit (minutes after midnight)" - i(13), "standard deviation from mean" - i(94), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(96), "% pay cashier (instead of at pump)" - i(8), "payment method" - s("credit"), "preferred pump" - s("37HG"), "preferred pump %" - i(41)])).
car(354, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("0ZNI715"), "year" - i(2005), "month" - i(2), "day" - i(16), "hour" - i(20), "minute" - i(11), "station" - s("shell"), "fill-ups" - i(14), "record history (days)" - i(108), "weekdays" - i(7), "weekends" - i(7), "preferred day" - s("sunday"), "day preference %" - i(28), "mean time of visit (minutes after midnight)" - i(73), "standard deviation from mean" - i(245), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(85), "% pay cashier (instead of at pump)" - i(15), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(42)])).
car(355, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("0ENI715"), "year" - i(2005), "month" - i(3), "day" - i(1), "hour" - i(19), "minute" - i(20), "station" - s("mobil"), "fill-ups" - i(46), "record history (days)" - i(170), "weekdays" - i(30), "weekends" - i(16), "preferred day" - s("friday"), "day preference %" - i(36), "mean time of visit (minutes after midnight)" - i(30), "standard deviation from mean" - i(197), "different locations" - i(3), "preferred station" - s("mobil"), "preferred station %" - i(91), "% pay cashier (instead of at pump)" - i(6), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(50)])).
car(356, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("7CNI915"), "year" - i(2005), "month" - i(2), "day" - i(27), "hour" - i(14), "minute" - i(10), "station" - s("mobil"), "fill-ups" - i(67), "record history (days)" - i(141), "weekdays" - i(61), "weekends" - i(6), "preferred day" - s("wednesday"), "day preference %" - i(26), "mean time of visit (minutes after midnight)" - i(13), "standard deviation from mean" - i(108), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(92), "% pay cashier (instead of at pump)" - i(4), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(49)])).
car(357, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("2CNI015"), "year" - i(2005), "month" - i(2), "day" - i(27), "hour" - i(0), "minute" - i(38), "station" - s("mobil"), "fill-ups" - i(39), "record history (days)" - i(163), "weekdays" - i(27), "weekends" - i(12), "preferred day" - s("wednesday"), "day preference %" - i(20), "mean time of visit (minutes after midnight)" - i(36), "standard deviation from mean" - i(220), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(97), "% pay cashier (instead of at pump)" - i(7), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(30)])).
car(358, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("3VNI597"), "year" - i(2005), "month" - i(3), "day" - i(4), "hour" - i(9), "minute" - i(41), "station" - s("mobil"), "fill-ups" - i(129), "record history (days)" - i(149), "weekdays" - i(100), "weekends" - i(29), "preferred day" - s("tuesday"), "day preference %" - i(17), "mean time of visit (minutes after midnight)" - i(11), "standard deviation from mean" - i(127), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(97), "% pay cashier (instead of at pump)" - i(4), "payment method" - s("credit"), "preferred pump" - s("07HG"), "preferred pump %" - i(34)])).
car(359, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("0ZNI907"), "year" - i(2005), "month" - i(2), "day" - i(6), "hour" - i(11), "minute" - i(32), "station" - s("mobil"), "fill-ups" - i(83), "record history (days)" - i(148), "weekdays" - i(61), "weekends" - i(22), "preferred day" - s("tuesday"), "day preference %" - i(19), "mean time of visit (minutes after midnight)" - i(15), "standard deviation from mean" - i(137), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(81), "% pay cashier (instead of at pump)" - i(5), "payment method" - s("credit"), "preferred pump" - s("27HG"), "preferred pump %" - i(21)])).
car(360, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("4BNI129"), "year" - i(2004), "month" - i(10), "day" - i(3), "hour" - i(5), "minute" - i(13), "station" - s("mobil"), "fill-ups" - i(11), "record history (days)" - i(95), "weekdays" - i(8), "weekends" - i(3), "preferred day" - s("tuesday"), "day preference %" - i(27), "mean time of visit (minutes after midnight)" - i(91), "standard deviation from mean" - i(277), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(18), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(54)])).
car(361, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("0XNI039"), "year" - i(2004), "month" - i(12), "day" - i(2), "hour" - i(16), "minute" - i(24), "station" - s("mobil"), "fill-ups" - i(21), "record history (days)" - i(145), "weekdays" - i(21), "weekends" - i(0), "preferred day" - s("thursday"), "day preference %" - i(33), "mean time of visit (minutes after midnight)" - i(54), "standard deviation from mean" - i(240), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(95), "% pay cashier (instead of at pump)" - i(9), "payment method" - s("credit"), "preferred pump" - s("17HG"), "preferred pump %" - i(38)])).
car(362, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("2142QHI"), "year" - i(2004), "month" - i(12), "day" - i(25), "hour" - i(15), "minute" - i(44), "station" - s("mobil"), "fill-ups" - i(6), "record history (days)" - i(140), "weekdays" - i(3), "weekends" - i(3), "preferred day" - s("sunday"), "day preference %" - i(50), "mean time of visit (minutes after midnight)" - i(211), "standard deviation from mean" - i(378), "different locations" - i(1), "preferred station" - s("mobil"), "preferred station %" - i(100), "% pay cashier (instead of at pump)" - i(20), "payment method" - s("credit"), "preferred pump" - s("47HG"), "preferred pump %" - i(83)])).
car(363, class("fill up only"), attributes(["state/province" - s("MM"), "tag" - s("3510RHI"), "year" - i(2005), "month" - i(1), "day" - i(6), "hour" - i(13), "minute" - i(43), "station" - s("mobil"), "fill-ups" - i(24), "record history (days)" - i(148), "weekdays" - i(17), "weekends" - i(7), "preferred day" - s("thursday"), "day preference %" - i(20), "mean time of visit (minutes after midnight)" - i(33), "standard deviation from mean" - i(141), "different locations" - i(2), "preferred station" - s("mobil"), "preferred station %" - i(95), "% pay cashier (instead of at pump)" - i(10), "payment method" - s("credit"), "preferred pump" - s("57HG"), "preferred pump %" - i(50)])).
